/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.launcher;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.testing.Testing;
import com.google.api.services.testing.model.AndroidDeviceCatalog;
import com.google.api.services.testing.model.TestEnvironmentCatalog;
import com.google.api.services.toolresults.Toolresults;
import com.google.gct.login.GoogleLogin;
import com.google.gct.testing.CloudTestingUtils;

public class CloudAuthenticator {
    private static final String APPLICATION_NAME = "GCTL";
    private static HttpTransport httpTransport;
    private static Credential credential;
    private static Storage storage;
    private static Testing test;
    private static Toolresults toolresults;
    private static long lastDiscoveryServiceInvocationTimestamp;

    public static Storage getPublicStorage() {
        if (httpTransport == null) {
            httpTransport = CloudAuthenticator.createHttpTransport();
        }
        return new Storage.Builder(httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), null).setApplicationName(APPLICATION_NAME).build();
    }

    public static Storage getStorage() {
        CloudAuthenticator.prepareCredential();
        if (storage == null) {
            storage = new Storage.Builder(httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
        }
        return storage;
    }

    public static void recreateTestAndToolResults(String testBackendUrl, String toolResultsBackendUrl) {
        CloudAuthenticator.prepareCredential();
        test = new Testing.Builder(httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).setRootUrl(testBackendUrl).build();
        toolresults = new Toolresults.Builder(httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).setRootUrl(toolResultsBackendUrl).build();
    }

    public static Testing getTest() {
        CloudAuthenticator.prepareCredential();
        if (test == null) {
            test = new Testing.Builder(httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidDeviceCatalog getAndroidDeviceCatalog() {
        long currentTimestamp = System.currentTimeMillis();
        try {
            AndroidDeviceCatalog catalog = ((TestEnvironmentCatalog)CloudAuthenticator.getTest().testEnvironmentCatalog().get("ANDROID").execute()).getAndroidDeviceCatalog();
            if (catalog.getVersions().isEmpty() || catalog.getModels().isEmpty() || catalog.getRuntimeConfiguration().getLocales().isEmpty() || catalog.getRuntimeConfiguration().getOrientations().isEmpty()) {
                CloudAuthenticator.showDeviceCatalogError("Android device catalog is empty for some dimensions", currentTimestamp);
            }
            AndroidDeviceCatalog androidDeviceCatalog = catalog;
            return androidDeviceCatalog;
        }
        catch (Exception e) {
            CloudAuthenticator.showDeviceCatalogError("Exception while getting Android device catalog\n\n" + e.getMessage(), currentTimestamp);
            AndroidDeviceCatalog androidDeviceCatalog = null;
            return androidDeviceCatalog;
        }
        finally {
            lastDiscoveryServiceInvocationTimestamp = currentTimestamp;
        }
    }

    private static void showDeviceCatalogError(String errorMessageSuffix, long currentTimestamp) {
        if (currentTimestamp - lastDiscoveryServiceInvocationTimestamp > 1000L) {
            CloudTestingUtils.showErrorMessage(null, "Error retrieving android device catalog", "Failed to retrieve available firebase devices! Please try again later.\n" + errorMessageSuffix);
        }
    }

    public static Toolresults getToolresults() {
        CloudAuthenticator.prepareCredential();
        if (toolresults == null) {
            toolresults = new Toolresults.Builder(httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)credential).setApplicationName(APPLICATION_NAME).build();
        }
        return toolresults;
    }

    public static void prepareCredential() {
        if (httpTransport == null) {
            httpTransport = CloudAuthenticator.createHttpTransport();
        }
        if (credential == null) {
            if (!CloudAuthenticator.authorize()) {
                throw new RuntimeException("Failed to authorize to Google Cloud!");
            }
            credential = GoogleLogin.getInstance().getCredential();
        }
    }

    private static HttpTransport createHttpTransport() {
        try {
            return GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw new RuntimeException("Failed to acquire HTTP transport for Google Cloud Storage!");
        }
    }

    public static boolean authorize() {
        GoogleLogin googleLogin = GoogleLogin.getInstance();
        Credential credential = googleLogin.getCredential();
        if (credential == null) {
            googleLogin.logIn();
            credential = googleLogin.getCredential();
            if (credential == null) {
                return false;
            }
        }
        return true;
    }

    public static boolean isUserLoggedIn() {
        return GoogleLogin.getInstance().getCredential() != null;
    }

    static {
        lastDiscoveryServiceInvocationTimestamp = -1L;
    }
}

