/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.android.tools.idea.stats.UsageTracker;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.ConfigurationInstance;
import com.google.gct.testing.ConfigurationResult;
import com.google.gct.testing.ScreenshotComparisonHeaderPanelListener;
import com.google.gct.testing.ScreenshotComparisonPanel;
import com.google.gct.testing.TestName;
import com.google.gct.testing.ui.AddCompareScreenshotPanel;
import com.google.gct.testing.ui.AddScreenshotListener;
import com.google.gct.testing.ui.WipePanel;
import com.google.gct.testing.ui.WipePanelCallback;
import com.google.gct.testing.util.CloudTestingTracking;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nullable;

public class ScreenshotComparisonDialog {
    private final Set<ScreenshotComparisonHeaderPanelListener> headerListeners;
    private final Project myProject;
    private final AbstractTestProxy testTreeRoot;
    private final CloudConfigurationImpl configuration;
    private final ConfigurationInstance configurationInstance;
    @Nullable
    private final ConfigurationInstance anotherConfigurationInstance;
    private final List<TestName> allTests;
    private TestName currentTest;
    private final Map<String, ConfigurationResult> results;
    private int step;
    private int maxStep;
    private final List<ScreenshotComparisonPanel> screenshotPanels;
    private final Map<TestName, Integer> testToStep;
    private JPanel myPanel;
    private JPanel myHeaderPanel;
    private JPanel myAllScreenshotsPanel;
    private JPanel myLeftHeaderPanel;
    private JPanel myRightHeaderPanel;
    private JPanel myScreenshotNamePanel;
    private JLabel myScreenshotNameLabel;
    private Window myWindow;
    private JComboBox myTestComboBox;
    private JLabel myStepLabel;
    private AddCompareScreenshotPanel addScreenshotPanel;
    private ActionButton myDecrementStepButton;
    private ActionButton myIncrementStepButton;
    private volatile int loadedScreenshotsCount;

    public ScreenshotComparisonDialog(Project project, AbstractTestProxy testTreeRoot, CloudConfigurationImpl configuration, ConfigurationInstance configurationInstance, @Nullable ConfigurationInstance anotherConfigurationInstance, List<TestName> allTests, TestName currentTest, Map<String, ConfigurationResult> results) {
        this.$$$setupUI$$$();
        this.headerListeners = new HashSet<ScreenshotComparisonHeaderPanelListener>();
        this.step = 1;
        this.maxStep = 1;
        this.screenshotPanels = new LinkedList<ScreenshotComparisonPanel>();
        this.testToStep = new HashMap<TestName, Integer>();
        this.loadedScreenshotsCount = 0;
        this.myProject = project;
        this.testTreeRoot = testTreeRoot;
        this.configuration = configuration;
        this.configurationInstance = configurationInstance;
        this.anotherConfigurationInstance = anotherConfigurationInstance;
        this.allTests = allTests;
        this.currentTest = currentTest;
        this.results = results;
        for (TestName test : allTests) {
            this.testToStep.put(test, 1);
        }
    }

    public void showDialog() {
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setCenterPanel((JComponent)this.myPanel);
        builder.setPreferredFocusComponent((JComponent)this.myLeftHeaderPanel);
        builder.setTitle("Screenshot Viewer");
        builder.removeAllActions();
        this.populateHeaderPanel();
        this.createFirstScreenshotComparisonPanel(this.configurationInstance);
        this.addScreenshotPanel = new AddCompareScreenshotPanel();
        this.addScreenshotPanel.addListener(new AddScreenshotListener(){

            @Override
            public void addScreenshot() {
                ScreenshotComparisonDialog.this.addScreenshotComparisonPanel((ScreenshotComparisonPanel)ScreenshotComparisonDialog.this.screenshotPanels.get(ScreenshotComparisonDialog.this.screenshotPanels.size() - 1));
            }
        });
        this.myAllScreenshotsPanel.add(this.addScreenshotPanel.getPanel());
        this.myTestComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestName selectedTest = (TestName)ScreenshotComparisonDialog.this.myTestComboBox.getSelectedItem();
                if (!selectedTest.equals(ScreenshotComparisonDialog.this.currentTest)) {
                    ScreenshotComparisonDialog.this.testToStep.put(ScreenshotComparisonDialog.this.currentTest, ScreenshotComparisonDialog.this.step);
                    ScreenshotComparisonDialog.this.currentTest = selectedTest;
                    ScreenshotComparisonDialog.this.step = (Integer)ScreenshotComparisonDialog.this.testToStep.get(ScreenshotComparisonDialog.this.currentTest);
                    ScreenshotComparisonDialog.this.notifyHeaderListenersAboutStep(false);
                }
                for (ScreenshotComparisonHeaderPanelListener headerListener : ScreenshotComparisonDialog.this.headerListeners) {
                    headerListener.updateTest(selectedTest, true);
                }
                ScreenshotComparisonDialog.this.updateMaxStep();
            }
        });
        this.myTestComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof TestName) {
                    TestName testName = (TestName)value;
                    label.setText(testName.getDisplayName());
                }
                return label;
            }
        });
        this.myWindow = builder.getWindow();
        this.updateMaxStep();
        this.updateScreenshotName();
        builder.show();
        UsageTracker.getInstance().trackEvent("com.google.cloud.testing", "compare.screenshots.opened", CloudTestingTracking.SESSION_LABEL, Integer.valueOf(this.loadedScreenshotsCount));
    }

    public Window getWindow() {
        return this.myWindow;
    }

    private void createFirstScreenshotComparisonPanel(ConfigurationInstance configurationInstance) {
        ScreenshotComparisonPanel screenshotComparisonPanel = new ScreenshotComparisonPanel(this, null, this.testTreeRoot, this.configuration, configurationInstance, (TestName)this.myTestComboBox.getSelectedItem(), this.step, this.results);
        this.screenshotPanels.add(screenshotComparisonPanel);
        WipePanel wipePanel = screenshotComparisonPanel.getPanel();
        this.myAllScreenshotsPanel.add(wipePanel);
        wipePanel.instantReveal(new WipePanelCallback(){

            @Override
            public void panelRevealed() {
                ScreenshotComparisonDialog.this.fitWindow();
            }
        });
        this.headerListeners.add(screenshotComparisonPanel);
    }

    private void populateHeaderPanel() {
        this.myTestComboBox = new JComboBox();
        this.myTestComboBox.setModel(new DefaultComboBoxModel<TestName>(new Vector<TestName>(this.allTests)));
        this.myTestComboBox.setSelectedItem(this.currentTest);
        this.myLeftHeaderPanel.add(this.myTestComboBox);
        this.myScreenshotNameLabel = new JLabel("");
        this.myScreenshotNameLabel.setFont(this.myScreenshotNameLabel.getFont().deriveFont(1).deriveFont(18.0f));
        this.myScreenshotNamePanel.add(this.myScreenshotNameLabel);
        this.myScreenshotNamePanel.setBorder(new EmptyBorder(0, 15, 0, 0));
        AnAction decrementStepAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ScreenshotComparisonDialog.this.step--;
                if (ScreenshotComparisonDialog.this.step < 1) {
                    ScreenshotComparisonDialog.this.step = 1;
                }
                ScreenshotComparisonDialog.this.updateStepLabel();
                ScreenshotComparisonDialog.this.notifyHeaderListenersAboutStep(true);
            }

            public void update(AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                presentation.setIcon(AllIcons.Actions.Back);
            }
        };
        PresentationFactory presentationFactory = new PresentationFactory();
        this.myDecrementStepButton = new ActionButton(decrementStepAction, presentationFactory.getPresentation(decrementStepAction), "MyPlace", new Dimension(25, 25));
        this.myRightHeaderPanel.add((Component)this.myDecrementStepButton);
        this.myStepLabel = new JLabel();
        this.myRightHeaderPanel.add(this.myStepLabel);
        AnAction incrementStepAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ScreenshotComparisonDialog.this.step++;
                if (ScreenshotComparisonDialog.this.step > ScreenshotComparisonDialog.this.maxStep) {
                    ScreenshotComparisonDialog.this.step = ScreenshotComparisonDialog.this.maxStep;
                }
                ScreenshotComparisonDialog.this.updateStepLabel();
                ScreenshotComparisonDialog.this.notifyHeaderListenersAboutStep(true);
            }

            public void update(AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                presentation.setIcon(AllIcons.Actions.Forward);
            }
        };
        this.myIncrementStepButton = new ActionButton(incrementStepAction, presentationFactory.getPresentation(incrementStepAction), "MyPlace", new Dimension(25, 25));
        this.myRightHeaderPanel.add((Component)this.myIncrementStepButton);
        this.updateStepLabel();
    }

    private void notifyHeaderListenersAboutStep(boolean shouldUpdateImage) {
        this.updateScreenshotName();
        for (ScreenshotComparisonHeaderPanelListener headerListener : this.headerListeners) {
            headerListener.updateStep(this.step, shouldUpdateImage);
        }
    }

    private void updateScreenshotName() {
        this.myScreenshotNameLabel.setText("Screenshot name");
        for (ConfigurationResult result : this.results.values()) {
            String screenshotName = result.getScreenshotNameForTestAndStep(this.currentTest, this.step);
            if (screenshotName.isEmpty()) continue;
            this.myScreenshotNameLabel.setText(screenshotName);
            break;
        }
    }

    private void updateStepLabel() {
        this.myStepLabel.setText("Screenshot " + this.step + "/" + this.maxStep);
        this.myDecrementStepButton.setEnabled(this.step > 1);
        this.myIncrementStepButton.setEnabled(this.step < this.maxStep);
    }

    public void addScreenshotComparisonPanel(ScreenshotComparisonPanel createAfterPanel) {
        int index = 0;
        for (Component component : this.myAllScreenshotsPanel.getComponents()) {
            if (component == createAfterPanel.getPanel()) {
                ScreenshotComparisonPanel screenshotComparisonPanel = new ScreenshotComparisonPanel(this, createAfterPanel, this.testTreeRoot, this.configuration, createAfterPanel.computeSelectedConfigurationInstance(), (TestName)this.myTestComboBox.getSelectedItem(), this.step, this.results);
                this.screenshotPanels.add(index + 1, screenshotComparisonPanel);
                this.updateMaxStep();
                WipePanel newPanel = screenshotComparisonPanel.getPanel();
                this.myAllScreenshotsPanel.add((Component)newPanel, index + 1);
                this.headerListeners.add(screenshotComparisonPanel);
                this.fitWindow();
                newPanel.reveal(null);
                return;
            }
            ++index;
        }
        throw new IllegalArgumentException("Could not find panel to insert after: " + createAfterPanel);
    }

    public void fitWindow() {
        if (this.myWindow == null) {
            return;
        }
        this.myAllScreenshotsPanel.updateUI();
        this.myWindow.pack();
        int maxHeight = 0;
        for (ScreenshotComparisonPanel panel : this.screenshotPanels) {
            if (panel.getPanel().getHeight() <= maxHeight) continue;
            maxHeight = panel.getPanel().getHeight();
        }
        this.addScreenshotPanel.setHeight(maxHeight);
        this.myAllScreenshotsPanel.updateUI();
        this.myWindow.pack();
    }

    public void removeScreenshotComparisonPanel(final ScreenshotComparisonPanel removedPanel) {
        WipePanel panel = removedPanel.getPanel();
        panel.unReveal(new WipePanelCallback(){

            @Override
            public void panelHidden(WipePanel panel) {
                ScreenshotComparisonDialog.this.headerListeners.remove(removedPanel);
                ScreenshotComparisonDialog.this.screenshotPanels.remove(removedPanel);
                removedPanel.stopListeningToResults();
                ScreenshotComparisonDialog.this.myAllScreenshotsPanel.remove(panel);
                if (ScreenshotComparisonDialog.this.myAllScreenshotsPanel.getComponentCount() == 1) {
                    ScreenshotComparisonDialog.this.myWindow.dispose();
                } else {
                    ScreenshotComparisonDialog.this.updateMaxStep();
                    ScreenshotComparisonDialog.this.fitWindow();
                }
            }
        });
    }

    void updateMaxStep() {
        this.maxStep = (Integer)Ordering.natural().max(Iterables.transform(this.screenshotPanels, (Function)new Function<ScreenshotComparisonPanel, Integer>(){

            public Integer apply(ScreenshotComparisonPanel panel) {
                return panel.getMaxStep();
            }
        }));
        int oldStep = this.step;
        this.step = Math.min(this.step, this.maxStep);
        if (this.step == 0 && this.maxStep != 0) {
            this.step = 1;
        }
        this.updateStepLabel();
        if (this.step != oldStep) {
            this.notifyHeaderListenersAboutStep(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementLoadedScreenshotsCount() {
        ScreenshotComparisonDialog screenshotComparisonDialog = this;
        synchronized (screenshotComparisonDialog) {
            ++this.loadedScreenshotsCount;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        this.myPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        this.myHeaderPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel5, "North");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel7, "North");
        this.myLeftHeaderPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 5, 5));
        jPanel7.add((Component)jPanel4, "West");
        this.myRightHeaderPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2, 5, 5));
        jPanel7.add((Component)jPanel3, "East");
        this.myScreenshotNamePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, "Center");
        this.myAllScreenshotsPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        jPanel6.add((Component)jPanel, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

