/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba;

import com.michaelbaranov.microba.common.MicrobaComponent;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class Microba {
    private static UIChangeListener changeListener = new UIChangeListener();
    private static Map lookAndFeelToOverride = new HashMap();

    public static synchronized void init() {
        Microba.setLookAndFeelProperties(UIManager.getLookAndFeel());
        UIManager.removePropertyChangeListener(changeListener);
        UIManager.addPropertyChangeListener(changeListener);
    }

    private static synchronized void setLookAndFeelProperties(LookAndFeel lookAndFeel) {
        if (lookAndFeel == null) {
            return;
        }
        String packagePrefix = "com.michaelbaranov.microba.";
        UIManager.put("microba.CalendarPaneUI", packagePrefix + "calendar.ui.basic.BasicCalendarPaneUI");
        UIManager.put("microba.DatePickerUI", packagePrefix + "calendar.ui.basic.BasicDatePickerUI");
        UIManager.put("microba.GradientUI", packagePrefix + "gradient.ui.basic.BasicGradientUI");
        UIManager.put("microba.GradientEditorUI", packagePrefix + "gradienteditor.ui.basic.BasicGradientEditorUI");
        UIManager.put("microba.MarkerBarUI", packagePrefix + "marker.ui.basic.BasicMarkerBarUI");
        if (lookAndFeel.getID().equals("Windows")) {
            UIManager.put("microba.MarkerBarUI", packagePrefix + "marker.ui.windows.WindowsMarkerBarUI");
        } else if (lookAndFeel.getID().equals("Metal")) {
            UIManager.put("microba.MarkerBarUI", packagePrefix + "marker.ui.metal.MetalMarkerBarUI");
        } else if (lookAndFeel.getID().equals("Motif")) {
            UIManager.put("microba.MarkerBarUI", packagePrefix + "marker.ui.motif.MotifMarkerBarUI");
        }
    }

    public static void setColorOverrideMap(String lookAndFeel, Map overrides) {
        lookAndFeelToOverride.put(lookAndFeel, overrides);
    }

    public static synchronized Color getOverridenColor(String colorConstant, MicrobaComponent component) {
        Map componentOverrideMap = component.getColorOverrideMap();
        if (componentOverrideMap != null && componentOverrideMap.containsKey(colorConstant)) {
            Object val = componentOverrideMap.get(colorConstant);
            if (val instanceof Color) {
                return (Color)val;
            }
            return UIManager.getColor(val);
        }
        String currentLookAndFeel = UIManager.getLookAndFeel().getID();
        Map overrides = (Map)lookAndFeelToOverride.get(currentLookAndFeel);
        if (overrides != null && overrides.containsKey(colorConstant)) {
            Object val = overrides.get(colorConstant);
            if (val instanceof Color) {
                return (Color)val;
            }
            return UIManager.getColor(val);
        }
        return null;
    }

    public static synchronized Color getOverridenColor(String colorConstant, MicrobaComponent component, Color defaultColor) {
        Color overriden = Microba.getOverridenColor(colorConstant, component);
        if (overriden != null) {
            return overriden;
        }
        return defaultColor;
    }

    private static final class UIChangeListener
    implements PropertyChangeListener {
        private UIChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("lookAndFeel".equals(event.getPropertyName())) {
                Microba.setLookAndFeelProperties((LookAndFeel)event.getNewValue());
            }
        }
    }
}

