/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.TaskExecutor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.HashMap;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.util.PtyUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    private final Charset myDefaultCharset = CharsetToolkit.UTF8_CHARSET;

    public LocalTerminalDirectRunner(Project project) {
        super(project);
    }

    private static boolean hasLoginArgument(String name) {
        return name.equals("bash") || name.equals("sh") || name.equals("zsh");
    }

    private static String getShellName(String path) {
        return new File(path).getName();
    }

    private static File findRCFile() {
        try {
            File rcFile;
            String folder = PtyUtil.getPtyLibFolderPath();
            if (folder != null && (rcFile = new File(folder, "jediterm.in")).exists()) {
                return rcFile;
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to get JAR folder", (Throwable)e);
        }
        return null;
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        return new LocalTerminalDirectRunner(project);
    }

    @Override
    protected PtyProcess createProcess(@Nullable String directory) throws ExecutionException {
        HashMap envs = new HashMap(System.getenv());
        envs.put("TERM", "xterm-256color");
        EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((Map)envs, (Charset)this.myDefaultCharset);
        try {
            return PtyProcess.exec((String[])this.getCommand(), (Map)envs, (String)(directory != null ? directory : this.currentProjectFolder()));
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    private String currentProjectFolder() {
        VirtualFile baseDir;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        VirtualFile[] roots = projectRootManager.getContentRoots();
        if (roots.length == 1) {
            roots[0].getCanonicalPath();
        }
        return (baseDir = this.myProject.getBaseDir()) == null ? null : baseDir.getCanonicalPath();
    }

    @Override
    protected ProcessHandler createProcessHandler(PtyProcess process) {
        return new PtyProcessHandler(process, this.getCommand()[0]);
    }

    @Override
    protected TtyConnector createTtyConnector(PtyProcess process) {
        return new PtyProcessTtyConnector(process, this.myDefaultCharset);
    }

    @Override
    public String runningTargetName() {
        return "Local Terminal";
    }

    @Override
    protected String getTerminalConnectionName(PtyProcess process) {
        return "Local Terminal";
    }

    public String[] getCommand() {
        String[] command;
        String shellPath = TerminalOptionsProvider.getInstance().getShellPath();
        if (SystemInfo.isUnix) {
            File rcFile = LocalTerminalDirectRunner.findRCFile();
            String shellName = LocalTerminalDirectRunner.getShellName(shellPath);
            command = rcFile != null && (shellName.equals("bash") || shellName.equals("sh")) ? new String[]{shellPath, "--rcfile", rcFile.getAbsolutePath(), "-i"} : (LocalTerminalDirectRunner.hasLoginArgument(shellName) ? new String[]{shellPath, "--login"} : shellPath.split(" "));
        } else {
            command = new String[]{shellPath};
        }
        return command;
    }

    private static class PtyProcessHandler
    extends ProcessHandler
    implements TaskExecutor {
        private final PtyProcess myProcess;
        private final ProcessWaitFor myWaitFor;

        public PtyProcessHandler(PtyProcess process, @NotNull String presentableName) {
            this.myProcess = process;
            this.myWaitFor = new ProcessWaitFor((Process)process, (TaskExecutor)this, presentableName);
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    try {
                        myWaitFor.setTerminationCallback((Consumer)new Consumer<Integer>(){

                            public void consume(Integer integer) {
                                this.notifyProcessTerminated(integer);
                            }
                        });
                    }
                    finally {
                        this.removeProcessListener((ProcessListener)this);
                    }
                }
            });
            super.startNotify();
        }

        protected void destroyProcessImpl() {
            this.myProcess.destroy();
        }

        protected void detachProcessImpl() {
            this.destroyProcessImpl();
        }

        public boolean detachIsDefault() {
            return false;
        }

        public boolean isSilentlyDestroyOnClose() {
            return true;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myProcess.getOutputStream();
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task) {
            return AppExecutorUtil.getAppExecutorService().submit(task);
        }
    }
}

