/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.api.Dependency;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Repository;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.RepoPackageImpl;
import java.io.File;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class LocalPackageImpl
extends RepoPackageImpl
implements LocalPackage {
    @XmlTransient
    private File mInstalledPath;

    @Override
    public File getLocation() {
        return this.mInstalledPath;
    }

    @Override
    public void setInstalledPath(File path) {
        this.mInstalledPath = path;
    }

    public static LocalPackageImpl create(RepoPackage p) {
        if (p instanceof LocalPackageImpl) {
            return (LocalPackageImpl)p;
        }
        CommonFactory f = (CommonFactory)RepoManager.getCommonModule().createLatestFactory();
        LocalPackageImpl result = f.createLocalPackage();
        result.setVersion(p.getVersion());
        result.setLicense(p.getLicense());
        result.setPath(p.getPath());
        for (Dependency d : p.getAllDependencies()) {
            result.addDependency(d);
        }
        result.setObsolete(p.obsolete());
        result.setTypeDetails(p.getTypeDetails());
        result.setDisplayName(p.getDisplayName());
        return result;
    }

    @Override
    public RepoPackageImpl asMarshallable() {
        return this;
    }

    @Override
    public void addTo(Repository repo) {
        repo.setLocalPackage(this);
    }
}

