/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractPackageOperation
implements PackageOperation {
    private static final String PATH_KEY = "path";
    private static final String CLASSNAME_KEY = "class";
    private static final String PREPARE_COMPLETE_FN = ".prepareComplete";
    private static final String INSTALL_DATA_FN = ".installData";
    static final String TEMP_DIR_PREFIX = "PackageOperation";
    private PackageOperation.InstallStatus mInstallStatus = PackageOperation.InstallStatus.NOT_STARTED;
    private Properties mInstallProperties;
    private List<PackageOperation.StatusChangeListener> mListeners = Lists.newArrayList();
    private final RepoManager mRepoManager;
    protected final FileOp mFop;

    protected AbstractPackageOperation(RepoManager repoManager, FileOp fop) {
        this.mRepoManager = repoManager;
        this.mFop = fop;
    }

    protected abstract boolean doPrepare(File var1, ProgressIndicator var2);

    protected abstract boolean doComplete(File var1, ProgressIndicator var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean complete(ProgressIndicator progress) {
        File installTemp;
        boolean result;
        block14: {
            progress.logInfo(String.format("Finishing \"%1$s\"", this.getName()));
            if (!this.updateStatus(PackageOperation.InstallStatus.RUNNING, progress)) {
                progress.setFraction(1.0);
                progress.setIndeterminate(false);
                progress.logInfo(String.format("\"%1$s\" failed.", this.getName()));
                return false;
            }
            if (this.mInstallProperties == null) {
                try {
                    this.mInstallProperties = AbstractPackageOperation.readInstallProperties(this.mFop.toPath(this.getLocation(progress)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            result = false;
            String installTempPath = null;
            if (this.mInstallProperties != null) {
                installTempPath = this.mInstallProperties.getProperty(PATH_KEY);
            }
            installTemp = installTempPath == null ? null : new File(installTempPath);
            try {
                if (InstallerUtil.checkValidPath(this.getLocation(progress), this.getRepoManager(), progress)) break block14;
                boolean bl = false;
                if (!result && progress.isCanceled()) {
                    this.cleanup(progress);
                }
                if ((result &= this.updateStatus(result ? PackageOperation.InstallStatus.COMPLETE : PackageOperation.InstallStatus.FAILED, progress)) && installTemp != null) {
                    this.mFop.deleteFileOrFolder(installTemp);
                }
                this.getRepoManager().installEnded(this.getPackage());
                this.getRepoManager().markLocalCacheInvalid();
                return bl;
            }
            catch (Throwable throwable) {
                if (!result && progress.isCanceled()) {
                    this.cleanup(progress);
                }
                if ((result &= this.updateStatus(result ? PackageOperation.InstallStatus.COMPLETE : PackageOperation.InstallStatus.FAILED, progress)) && installTemp != null) {
                    this.mFop.deleteFileOrFolder(installTemp);
                }
                this.getRepoManager().installEnded(this.getPackage());
                this.getRepoManager().markLocalCacheInvalid();
                throw throwable;
            }
        }
        result = this.doComplete(installTemp, progress);
        if (!result && progress.isCanceled()) {
            this.cleanup(progress);
        }
        if ((result &= this.updateStatus(result ? PackageOperation.InstallStatus.COMPLETE : PackageOperation.InstallStatus.FAILED, progress)) && installTemp != null) {
            this.mFop.deleteFileOrFolder(installTemp);
        }
        this.getRepoManager().installEnded(this.getPackage());
        this.getRepoManager().markLocalCacheInvalid();
        progress.setFraction(1.0);
        progress.setIndeterminate(false);
        progress.logInfo(String.format("\"%1$s\" %2$s.", this.getName(), result ? "complete" : "failed"));
        return result;
    }

    private static Properties readInstallProperties(Path installPath) throws IOException {
        Path metaDir = installPath.resolve(".installer");
        Path dataFile = metaDir.resolve(INSTALL_DATA_FN);
        if (Files.exists(dataFile, new LinkOption[0])) {
            Properties installProperties = new Properties();
            try (InputStream inStream = Files.newInputStream(dataFile, new OpenOption[0]);){
                installProperties.load(inStream);
                Properties properties = installProperties;
                return properties;
            }
        }
        return null;
    }

    private void cleanup(ProgressIndicator progress) {
        this.mFop.deleteFileOrFolder(new File(this.getLocation(progress), ".installer"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean prepare(ProgressIndicator progress) {
        progress.logInfo(String.format("Preparing \"%1$s\".", this.getName()));
        try {
            File dest = this.getLocation(progress);
            this.mInstallProperties = this.readOrCreateInstallProperties(dest, progress);
        }
        catch (IOException e) {
            progress.logWarning("Failed to read or create install properties file.");
            return false;
        }
        if (!this.updateStatus(PackageOperation.InstallStatus.PREPARING, progress)) {
            progress.logInfo(String.format("\"%1$s\"  failed.", this.getName()));
            return false;
        }
        this.getRepoManager().installBeginning(this.getPackage(), this);
        boolean result = false;
        try {
            if (!InstallerUtil.checkValidPath(this.getLocation(progress), this.getRepoManager(), progress)) {
                boolean bl = false;
                return bl;
            }
            File installTempPath = this.writeInstallerMetadata(progress);
            if (installTempPath == null) {
                progress.logInfo(String.format("\"%1$s\" failed.", this.getName()));
                boolean bl = false;
                return bl;
            }
            File prepareCompleteMarker = new File(installTempPath, PREPARE_COMPLETE_FN);
            if (!this.mFop.exists(prepareCompleteMarker)) {
                if (this.doPrepare(installTempPath, progress)) {
                    this.mFop.createNewFile(prepareCompleteMarker);
                    result = this.updateStatus(PackageOperation.InstallStatus.PREPARED, progress);
                }
            } else {
                progress.logInfo("Found existing prepared package.");
                result = true;
            }
        }
        catch (IOException e) {
            result = false;
        }
        finally {
            if (!result) {
                this.getRepoManager().installEnded(this.getPackage());
                this.updateStatus(PackageOperation.InstallStatus.FAILED, progress);
                if (progress.isCanceled()) {
                    this.cleanup(progress);
                }
            }
        }
        progress.logInfo(String.format("\"%1$s\" %2$s.", this.getName(), result ? "ready" : "failed"));
        return result;
    }

    private Properties readOrCreateInstallProperties(File affectedPath, ProgressIndicator progress) throws IOException {
        Properties installProperties = AbstractPackageOperation.readInstallProperties(this.mFop.toPath(affectedPath));
        if (installProperties != null) {
            return installProperties;
        }
        installProperties = new Properties();
        File metaDir = new File(affectedPath, ".installer");
        if (!this.mFop.exists(metaDir)) {
            this.mFop.mkdirs(metaDir);
        }
        File dataFile = new File(metaDir, INSTALL_DATA_FN);
        File installTempPath = FileOpUtils.getNewTempDir(TEMP_DIR_PREFIX, this.mFop);
        if (installTempPath == null) {
            this.deleteOrphanedTempDirs(progress);
            installTempPath = FileOpUtils.getNewTempDir(TEMP_DIR_PREFIX, this.mFop);
            if (installTempPath == null) {
                throw new IOException("Failed to create temp path");
            }
        }
        installProperties.put(PATH_KEY, installTempPath.getPath());
        installProperties.put(CLASSNAME_KEY, this.getClass().getName());
        this.mFop.createNewFile(dataFile);
        try (OutputStream out = this.mFop.newFileOutputStream(dataFile);){
            installProperties.store(out, null);
        }
        return installProperties;
    }

    private void deleteOrphanedTempDirs(ProgressIndicator progress) {
        Path root = this.mFop.toPath(this.mRepoManager.getLocalPath());
        Path suffixPath = this.mFop.toPath(new File(".installer", INSTALL_DATA_FN));
        try {
            Set<File> tempDirs = Files.walk(root, new FileVisitOption[0]).filter(path -> path.endsWith(suffixPath)).map(this::getPathPropertiesOrNull).filter(Objects::nonNull).map(props -> props.getProperty(PATH_KEY)).map(File::new).collect(Collectors.toSet());
            FileOpUtils.retainTempDirs(tempDirs, TEMP_DIR_PREFIX, this.mFop);
        }
        catch (IOException e) {
            progress.logWarning("Error while searching for in-use temporary directories.", e);
        }
    }

    private Properties getPathPropertiesOrNull(Path path) {
        try {
            return AbstractPackageOperation.readInstallProperties(path.getParent().getParent());
        }
        catch (IOException e) {
            return null;
        }
    }

    private File writeInstallerMetadata(ProgressIndicator progress) throws IOException {
        File installPath = this.getLocation(progress);
        Properties installProperties = this.readOrCreateInstallProperties(installPath, progress);
        File installTempPath = new File((String)installProperties.get(PATH_KEY));
        if (!this.mFop.exists(installPath) && !this.mFop.mkdirs(installPath) || !this.mFop.isDirectory(installPath)) {
            progress.logWarning("Failed to create output directory: " + installPath);
            return null;
        }
        this.mFop.deleteOnExit(installTempPath);
        return installTempPath;
    }

    @Override
    public RepoManager getRepoManager() {
        return this.mRepoManager;
    }

    @Override
    public final void registerStateChangeListener(PackageOperation.StatusChangeListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public final PackageOperation.InstallStatus getInstallStatus() {
        return this.mInstallStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean updateStatus(PackageOperation.InstallStatus status, ProgressIndicator progress) {
        this.mInstallStatus = status;
        try {
            for (PackageOperation.StatusChangeListener listener : this.mListeners) {
                try {
                    listener.statusChanged(this, progress);
                }
                catch (Exception e) {
                    if (status == PackageOperation.InstallStatus.FAILED) continue;
                    throw e;
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.updateStatus(PackageOperation.InstallStatus.FAILED, progress);
            return false;
        }
    }
}

