/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.console.BuildAndRestartConsoleAction;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.shell.GroovyShellConfig;
import org.jetbrains.plugins.groovy.shell.GroovyShellLanguageConsoleView;

public class GroovyShellRunnerImpl
extends AbstractConsoleRunnerWithHistory<LanguageConsoleView> {
    private static final Logger LOG = Logger.getInstance(GroovyShellRunnerImpl.class);
    public static final Key<Boolean> GROOVY_SHELL_FILE = Key.create((String)"GROOVY_SHELL_FILE");
    public static final String GROOVY_SHELL_EXECUTE = "Groovy.Shell.Execute";
    private final GroovyShellConfig myShellRunner;
    private final Module myModule;
    private final Consumer<Module> myStarter = new Consumer<Module>(){

        public void consume(Module module) {
            GroovyShellRunnerImpl.doRunShell(GroovyShellRunnerImpl.this.myShellRunner, module);
        }
    };
    private GeneralCommandLine myCommandLine;

    public GroovyShellRunnerImpl(@NotNull String consoleTitle, @NotNull GroovyShellConfig shellRunner, @NotNull Module module) {
        super(module.getProject(), consoleTitle, shellRunner.getWorkingDirectory(module));
        this.myShellRunner = shellRunner;
        this.myModule = module;
    }

    protected List<AnAction> fillToolBarActions(DefaultActionGroup toolbarActions, Executor defaultExecutor, RunContentDescriptor contentDescriptor) {
        BuildAndRestartConsoleAction rebuildAction = new BuildAndRestartConsoleAction(this.myModule, this.getProject(), defaultExecutor, contentDescriptor, this.myStarter);
        toolbarActions.add((AnAction)rebuildAction);
        List actions = super.fillToolBarActions(toolbarActions, defaultExecutor, contentDescriptor);
        actions.add(rebuildAction);
        return actions;
    }

    protected LanguageConsoleView createConsoleView() {
        GroovyShellLanguageConsoleView res = new GroovyShellLanguageConsoleView(this.getProject(), this.getConsoleTitle());
        GroovyFileImpl file = (GroovyFileImpl)res.getFile();
        assert (file.getContext() == null);
        file.putUserData(GROOVY_SHELL_FILE, Boolean.TRUE);
        file.setContext(this.myShellRunner.getContext(this.myModule));
        return res;
    }

    protected Process createProcess() throws ExecutionException {
        JavaParameters javaParameters = this.myShellRunner.createJavaParameters(this.myModule);
        Sdk sdk = ModuleRootManager.getInstance((Module)this.myModule).getSdk();
        assert (sdk != null);
        SdkTypeId sdkType = sdk.getSdkType();
        assert (sdkType instanceof JavaSdkType);
        String exePath = ((JavaSdkType)sdkType).getVMExecutablePath(sdk);
        this.myCommandLine = JdkUtil.setupJVMCommandLine((String)exePath, (SimpleJavaParameters)javaParameters, (boolean)true);
        return this.myCommandLine.createProcess();
    }

    protected OSProcessHandler createProcessHandler(Process process) {
        return new OSProcessHandler(process, this.myCommandLine.getCommandLineString());
    }

    @NotNull
    protected ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler() {
        ProcessBackedConsoleExecuteActionHandler handler = new ProcessBackedConsoleExecuteActionHandler(this.getProcessHandler(), false){

            public String getEmptyExecuteAction() {
                return GroovyShellRunnerImpl.GROOVY_SHELL_EXECUTE;
            }
        };
        new ConsoleHistoryController(this.getConsoleTitle(), null, this.getConsoleView()).install();
        return handler;
    }

    public static void doRunShell(GroovyShellConfig config, Module module) {
        try {
            new GroovyShellRunnerImpl(config.getTitle(), config, module).initAndRun();
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((Project)module.getProject(), (String)e.getMessage(), (String)("Cannot Run " + config.getTitle()));
        }
    }
}

