/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyShellCodeFragment
extends GroovyCodeFragment {
    private final Map<String, PsiVariable> myVariables = ContainerUtil.newHashMap();
    private final Map<String, GrTypeDefinition> myTypeDefinitions = ContainerUtil.newHashMap();

    public GroovyShellCodeFragment(Project project, LightVirtualFile virtualFile) {
        super(project, (VirtualFile)virtualFile);
    }

    @Override
    protected GroovyCodeFragment clone() {
        GroovyShellCodeFragment clone = (GroovyShellCodeFragment)super.clone();
        clone.myVariables.putAll(this.myVariables);
        clone.myTypeDefinitions.putAll(this.myTypeDefinitions);
        return clone;
    }

    public void addVariable(String name, GrExpression expr) {
        PsiType type = expr.getType();
        if (type instanceof GrClassReferenceType) {
            PsiClassType.ClassResolveResult resolveResult = ((GrClassReferenceType)type).resolveGenerics();
            PsiClass psiClass = resolveResult.getElement();
            PsiImmediateClassType psiImmediateClassType = type = psiClass == null ? null : new PsiImmediateClassType(psiClass, resolveResult.getSubstitutor());
        }
        if (type != null) {
            this.myVariables.put(name, new GrLightVariable(this.getManager(), name, type, (PsiElement)this));
        }
    }

    public void addVariable(String name, PsiType type) {
        this.myVariables.put(name, new GrLightVariable(this.getManager(), name, type, (PsiElement)this));
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (!this.processVariables(processor, state)) {
            return false;
        }
        return this.processTypeDefinitions(processor, state);
    }

    private boolean processVariables(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        String name;
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (!ResolveUtil.shouldProcessMethods(classHint) && !ResolveUtil.shouldProcessProperties(classHint)) {
            return true;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint != null ? nameHint.getName(state) : null;
        if (name != null) {
            PsiVariable var = this.myVariables.get(name);
            if (var != null && processor.execute((PsiElement)var, state)) {
                return false;
            }
        } else {
            for (PsiVariable var : this.myVariables.values()) {
                if (processor.execute((PsiElement)var, state)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processTypeDefinitions(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        String name;
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (!ResolveUtil.shouldProcessClasses(classHint)) {
            return true;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint != null ? nameHint.getName(state) : null;
        if (name != null) {
            GrTypeDefinition definition = this.myTypeDefinitions.get(name);
            if (definition != null && processor.execute((PsiElement)definition, state)) {
                return false;
            }
        } else {
            for (GrTypeDefinition definition : this.myTypeDefinitions.values()) {
                if (processor.execute((PsiElement)definition, state)) continue;
                return false;
            }
        }
        return true;
    }

    public void addTypeDefinition(GrTypeDefinition typeDefinition) {
        this.myTypeDefinitions.put(typeDefinition.getName(), typeDefinition);
    }

    public void clearVariables() {
        this.myVariables.clear();
    }

    public void clearClasses() {
        this.myTypeDefinitions.clear();
    }
}

