/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.variable;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.ui.NonFocusableCheckBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrAbstractInplaceIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrFinalListener;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrIntroduceVariableHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyIntroduceVariableSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyVariableValidator;
import org.jetbrains.plugins.groovy.settings.GroovyApplicationSettings;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public abstract class GrInplaceVariableIntroducer
extends GrAbstractInplaceIntroducer<GroovyIntroduceVariableSettings> {
    private JCheckBox myCanBeFinalCb;

    public GrInplaceVariableIntroducer(String title, OccurrencesChooser.ReplaceChoice replaceChoice, GrIntroduceContext context) {
        super(title, replaceChoice, context);
        this.setAdvertisementText(GrInplaceVariableIntroducer.getAdvertisementText());
    }

    @Nullable
    private static String getAdvertisementText() {
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts("PreviousTemplateVariable");
        if (shortcuts.length > 0) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to change type";
        }
        return null;
    }

    protected String getActionName() {
        return GrIntroduceVariableHandler.REFACTORING_NAME;
    }

    protected String[] suggestNames(boolean replaceAll, @Nullable GrVariable variable) {
        return GroovyNameSuggestionUtil.suggestVariableNames(this.getContext().getExpression(), new GroovyVariableValidator(this.getContext()));
    }

    protected JComponent getComponent() {
        this.myCanBeFinalCb = new NonFocusableCheckBox("Declare final");
        this.myCanBeFinalCb.setSelected(false);
        this.myCanBeFinalCb.setMnemonic('f');
        final GrFinalListener finalListener = new GrFinalListener(this.myEditor);
        this.myCanBeFinalCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new WriteCommandAction(GrInplaceVariableIntroducer.this.myProject, GrInplaceVariableIntroducer.this.getCommandName(), GrInplaceVariableIntroducer.this.getCommandName(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        PsiDocumentManager.getInstance((Project)GrInplaceVariableIntroducer.this.myProject).commitDocument(GrInplaceVariableIntroducer.this.myEditor.getDocument());
                        GrVariable variable = GrInplaceVariableIntroducer.this.getVariable();
                        if (variable != null) {
                            finalListener.perform(GrInplaceVariableIntroducer.this.myCanBeFinalCb.isSelected(), variable);
                        }
                    }
                }.execute();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(null);
        if (this.myCanBeFinalCb != null) {
            panel.add((Component)this.myCanBeFinalCb, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        panel.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    @Nullable
    protected GroovyIntroduceVariableSettings getInitialSettingsForInplace(final @NotNull GrIntroduceContext context, final @NotNull OccurrencesChooser.ReplaceChoice choice, final String[] names) {
        return new GroovyIntroduceVariableSettings(){
            private final CanonicalTypes.Type myType;
            {
                GrExpression expression = context.getExpression();
                StringPartInfo stringPart = context.getStringPart();
                GrVariable var = context.getVar();
                PsiType type = expression != null ? expression.getType() : (var != null ? var.getType() : (stringPart != null ? stringPart.getLiteral().getType() : null));
                this.myType = type != null && !PsiType.NULL.equals((Object)type) ? CanonicalTypes.createTypeWrapper((PsiType)type) : null;
            }

            @Override
            public boolean isDeclareFinal() {
                return GrInplaceVariableIntroducer.this.myCanBeFinalCb != null ? GrInplaceVariableIntroducer.this.myCanBeFinalCb.isSelected() : false;
            }

            @Override
            @Nullable
            public String getName() {
                return names[0];
            }

            @Override
            public boolean replaceAllOccurrences() {
                return choice == OccurrencesChooser.ReplaceChoice.ALL;
            }

            @Override
            @Nullable
            public PsiType getSelectedType() {
                return this.myType != null ? this.myType.getType(context.getPlace(), context.getPlace().getManager()) : null;
            }
        };
    }

    protected void addAdditionalVariables(TemplateBuilderImpl builder) {
        TypeConstraint[] typeConstraintArray;
        GrVariable variable = this.getVariable();
        assert (variable != null && variable.getInitializerGroovy() != null);
        PsiType initializerType = variable.getInitializerGroovy().getType();
        if (initializerType != null && !initializerType.equals(PsiType.NULL)) {
            SupertypeConstraint[] supertypeConstraintArray = new SupertypeConstraint[1];
            typeConstraintArray = supertypeConstraintArray;
            supertypeConstraintArray[0] = SupertypeConstraint.create(initializerType);
        } else {
            typeConstraintArray = TypeConstraint.EMPTY_ARRAY;
        }
        TypeConstraint[] constraints = typeConstraintArray;
        ChooseTypeExpression typeExpression = new ChooseTypeExpression(constraints, variable.getManager(), variable.getResolveScope(), true, GroovyApplicationSettings.getInstance().INTRODUCE_LOCAL_SELECT_DEF);
        GrTypeElement element = variable.getTypeElementGroovy() != null ? variable.getTypeElementGroovy() : PsiUtil.findModifierInList(variable.getModifierList(), "def");
        builder.replaceElement((PsiElement)element, "Variable_type", (Expression)typeExpression, true, true);
    }

    @Override
    protected GroovyIntroduceVariableSettings getSettings() {
        return new GroovyIntroduceVariableSettings(){

            @Override
            public boolean isDeclareFinal() {
                return GrInplaceVariableIntroducer.this.myCanBeFinalCb.isSelected();
            }

            @Override
            @Nullable
            public String getName() {
                return GrInplaceVariableIntroducer.this.getInputName();
            }

            @Override
            public boolean replaceAllOccurrences() {
                return GrInplaceVariableIntroducer.this.isReplaceAllOccurrences();
            }

            @Override
            @Nullable
            public PsiType getSelectedType() {
                return GrInplaceVariableIntroducer.this.getSelectedType();
            }
        };
    }

    protected void saveSettings(@NotNull GrVariable variable) {
        GroovyApplicationSettings.getInstance().INTRODUCE_LOCAL_SELECT_DEF = variable.getDeclaredType() == null;
    }

    protected int getCaretOffset() {
        return this.getVariable().getNameIdentifierGroovy().getTextRange().getEndOffset();
    }
}

