/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract.closure;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractInfoHelperBase;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.ExtractClosureProcessorBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfo;

public class ExtractClosureHelperImpl
extends ExtractInfoHelperBase
implements GrIntroduceParameterSettings {
    private final GrParametersOwner myOwner;
    private final PsiElement myToSearchFor;
    private final String myName;
    private final boolean myFinal;
    private final TIntArrayList myToRemove;
    private final boolean myGenerateDelegate;
    private final int myReplaceFieldsWithGetters;
    private final boolean myForceReturn;
    private final boolean myReplaceAllOccurrences;
    private PsiType myType = null;
    private final boolean myForceDef;

    public ExtractClosureHelperImpl(IntroduceParameterInfo info, String name, boolean declareFinal, TIntArrayList toRemove, boolean generateDelegate, int replaceFieldsWithGetters, boolean forceReturn, boolean replaceAllOccurrences, boolean forceDef) {
        super(info);
        this.myForceReturn = forceReturn;
        this.myReplaceAllOccurrences = replaceAllOccurrences;
        this.myForceDef = forceDef;
        this.myOwner = info.getToReplaceIn();
        this.myToSearchFor = info.getToSearchFor();
        this.myName = name;
        this.myFinal = declareFinal;
        this.myToRemove = toRemove;
        this.myGenerateDelegate = generateDelegate;
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
    }

    @Override
    @NotNull
    public GrParametersOwner getToReplaceIn() {
        return this.myOwner;
    }

    @Override
    public PsiElement getToSearchFor() {
        return this.myToSearchFor;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean declareFinal() {
        return this.myFinal;
    }

    @Override
    public TIntArrayList parametersToRemove() {
        return this.myToRemove;
    }

    @Override
    public int replaceFieldsWithGetters() {
        return this.myReplaceFieldsWithGetters;
    }

    @Override
    public boolean removeLocalVariable() {
        return false;
    }

    @Override
    public boolean replaceAllOccurrences() {
        return this.myReplaceAllOccurrences;
    }

    @Override
    public PsiType getSelectedType() {
        if (this.myForceDef) {
            return null;
        }
        if (this.myType == null) {
            PsiType[] parameters;
            GrClosableBlock closure = ExtractClosureProcessorBase.generateClosure(this);
            PsiType type = closure.getType();
            if (type instanceof PsiClassType && (parameters = ((PsiClassType)type).getParameters()).length == 1 && parameters[0] != null && parameters[0].equalsToText(PsiType.VOID.getBoxedTypeName())) {
                type = ((PsiClassType)type).rawType();
            }
            this.myType = type;
        }
        return this.myType;
    }

    @Override
    public boolean generateDelegate() {
        return this.myGenerateDelegate;
    }

    @Override
    public boolean isForceReturn() {
        return this.myForceReturn;
    }

    @Override
    @Nullable
    public GrVariable getVar() {
        return null;
    }

    @Override
    public GrExpression getExpression() {
        return null;
    }
}

