/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.overrideImplement;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.overrideImplement.GroovyOverrideImplementExploreUtil;
import org.jetbrains.plugins.groovy.overrideImplement.GroovyOverrideImplementUtil;

public class GroovyImplementMethodsHandler
implements LanguageCodeInsightActionHandler {
    public boolean isValidFor(Editor editor, PsiFile psiFile) {
        return psiFile != null && ((Object)((Object)GroovyFileType.GROOVY_FILE_TYPE)).equals(psiFile.getFileType());
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (!CodeInsightUtilBase.prepareEditorForWrite((Editor)editor)) {
            return;
        }
        PsiClass aClass = OverrideImplementUtil.getContextClass((Project)project, (Editor)editor, (PsiFile)file, (boolean)true);
        if (aClass instanceof GrTypeDefinition) {
            GrTypeDefinition typeDefinition = (GrTypeDefinition)aClass;
            if (GroovyOverrideImplementExploreUtil.getMethodSignaturesToImplement(typeDefinition).isEmpty()) {
                HintManager.getInstance().showErrorHint(editor, "No methods to implement have been found");
                return;
            }
            GroovyOverrideImplementUtil.chooseAndImplementMethods(project, editor, typeDefinition);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

