/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.mvc.projectView.ClassNode;
import org.jetbrains.plugins.groovy.mvc.projectView.MethodNode;
import org.jetbrains.plugins.groovy.mvc.projectView.TestMethodNode;

public class TestClassNode
extends ClassNode {
    private final Icon myMethodIcon;

    public TestClassNode(@NotNull Module module, @NotNull GrTypeDefinition controllerClass, @Nullable ViewSettings viewSettings, Icon methodIcon) {
        super(module, controllerClass, viewSettings);
        this.myMethodIcon = methodIcon;
    }

    @Override
    @Nullable
    protected MethodNode createNodeForMethod(Module module, GrMethod method) {
        boolean isTestMethod;
        if (method == null) {
            return null;
        }
        if (!DumbService.isDumb((Project)module.getProject()) && (isTestMethod = JUnitUtil.isTestMethod((Location)new PsiLocation(module.getProject(), (PsiElement)method)))) {
            return new TestMethodNode(module, method, this.getSettings(), this.myMethodIcon);
        }
        return new MethodNode(module, method, this.getSettings());
    }

    @Override
    protected String getTestPresentationImpl(@NotNull PsiElement psiElement) {
        return "Test class: " + ((GrTypeDefinition)psiElement).getName();
    }
}

