/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.mvc.projectView.AbstractMvcPsiNodeDescriptor;
import org.jetbrains.plugins.groovy.mvc.projectView.ClassNode;
import org.jetbrains.plugins.groovy.mvc.projectView.FileNode;

public class AbstractFolderNode
extends AbstractMvcPsiNodeDescriptor {
    private final String myPresentableText;

    protected AbstractFolderNode(@NotNull Module module, @NotNull PsiDirectory directory, @NotNull String presentableText, ViewSettings viewSettings, int weight) {
        super(module, viewSettings, (PsiElement)directory, weight);
        this.myPresentableText = presentableText;
    }

    @Override
    protected String getTestPresentationImpl(@NotNull PsiElement psiElement) {
        VirtualFile virtualFile = this.getVirtualFile();
        assert (virtualFile != null);
        return "Folder: " + virtualFile.getPresentableName();
    }

    @NotNull
    protected PsiDirectory getPsiDirectory() {
        return (PsiDirectory)this.extractPsiFromValue();
    }

    @Nullable
    protected Collection<AbstractTreeNode> getChildrenImpl() {
        PsiDirectory directory = this.getPsiDirectory();
        if (!directory.isValid()) {
            return Collections.emptyList();
        }
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (PsiDirectory psiDirectory : directory.getSubdirectories()) {
            children.add((AbstractTreeNode)this.createFolderNode(psiDirectory));
        }
        for (PsiDirectory psiDirectory : directory.getFiles()) {
            this.processNotDirectoryFile(children, (PsiFile)psiDirectory);
        }
        return children;
    }

    private AbstractFolderNode createFolderNode(PsiDirectory directory) {
        PsiDirectory realDirectory = directory;
        StringBuilder textBuilder = null;
        if (this.getSettings().isHideEmptyMiddlePackages()) {
            PsiDirectory[] subdirectories;
            while (realDirectory.getFiles().length <= 0 && (subdirectories = realDirectory.getSubdirectories()).length == 1) {
                if (textBuilder == null) {
                    textBuilder = new StringBuilder();
                    textBuilder.append(realDirectory.getName());
                }
                realDirectory = subdirectories[0];
                textBuilder.append('.').append(realDirectory.getName());
            }
        }
        String presentableText = textBuilder == null ? directory.getName() : textBuilder.toString();
        return new AbstractFolderNode(this.getModule(), realDirectory, presentableText, this.getSettings(), 100){

            @Override
            protected void processNotDirectoryFile(List<AbstractTreeNode> nodes, PsiFile file) {
                AbstractFolderNode.this.processNotDirectoryFile(nodes, file);
            }

            @Override
            protected AbstractTreeNode createClassNode(GrTypeDefinition typeDefinition) {
                return AbstractFolderNode.this.createClassNode(typeDefinition);
            }
        };
    }

    @Override
    protected void updateImpl(PresentationData data) {
        PsiDirectory psiDirectory = this.getPsiDirectory();
        data.setPresentableText(this.myPresentableText);
        for (IconProvider provider : (IconProvider[])Extensions.getExtensions((ExtensionPointName)IconProvider.EXTENSION_POINT_NAME)) {
            Icon icon = provider.getIcon((PsiElement)psiDirectory, 0);
            if (icon == null) continue;
            data.setIcon(icon);
            return;
        }
    }

    @Override
    protected boolean containsImpl(@NotNull VirtualFile file) {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        VirtualFile valueFile = ((PsiDirectory)psiElement).getVirtualFile();
        if (!VfsUtil.isAncestor((VirtualFile)valueFile, (VirtualFile)file, (boolean)false)) {
            return false;
        }
        Project project = psiElement.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(valueFile);
        if (module == null) {
            return fileIndex.getModuleForFile(file) == null;
        }
        return ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(file);
    }

    protected void processNotDirectoryFile(List<AbstractTreeNode> nodes, PsiFile file) {
        GrTypeDefinition[] definitions;
        if (file instanceof GroovyFile && (definitions = ((GroovyFile)file).getTypeDefinitions()).length > 0) {
            for (GrTypeDefinition typeDefinition : definitions) {
                nodes.add(this.createClassNode(typeDefinition));
            }
            return;
        }
        nodes.add((AbstractTreeNode)new FileNode(this.getModule(), file, this.getSettings()));
    }

    protected AbstractTreeNode createClassNode(GrTypeDefinition typeDefinition) {
        assert (this.getValue() != null);
        return new ClassNode(this.getModule(), typeDefinition, this.getSettings());
    }
}

