/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcProjectWithoutLibraryNotificator
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)new ReadTask(){

            public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                if (project.isDisposed()) {
                    return;
                }
                Pair pair = MvcProjectWithoutLibraryNotificator.findModuleWithoutLibrary(project);
                if (pair == null) {
                    return;
                }
                MvcFramework framework = (MvcFramework)pair.second;
                final Module module = (Module)pair.first;
                String name = framework.getFrameworkName();
                final Map<String, Runnable> actions = framework.createConfigureActions(module);
                StringBuilder content = new StringBuilder().append("<html><body>").append("Module ").append('\'').append(module.getName()).append('\'').append(" has no ").append(name).append(" SDK.");
                if (!actions.isEmpty()) {
                    content.append("<br/>");
                }
                content.append(StringUtil.join(actions.keySet(), (Function)new Function<String, String>(){

                    public String fun(String actionName) {
                        return String.format("<a href='%s'>%s</a>", actionName, actionName);
                    }
                }, (String)" "));
                content.append("</body></html>");
                new Notification(name + ".Configure", name + " SDK not found", content.toString(), NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                        if (module.isDisposed()) {
                            return;
                        }
                        Runnable runnable = (Runnable)actions.get(e.getDescription());
                        assert (runnable != null);
                        runnable.run();
                    }
                }).notify(project);
            }

            public void onCanceled(@NotNull ProgressIndicator indicator) {
                ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)this);
            }
        });
    }

    @Nullable
    private static Pair<Module, MvcFramework> findModuleWithoutLibrary(Project project) {
        MvcFramework[] frameworks = (MvcFramework[])MvcFramework.EP_NAME.getExtensions();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (MvcFramework framework : frameworks) {
                if (!framework.hasFrameworkStructure(module) || framework.hasFrameworkJar(module) || VfsUtil.findRelativeFile((VirtualFile)framework.findAppRoot(module), (String[])new String[]{"application.properties"}) == null) continue;
                return Pair.create((Object)module, (Object)framework);
            }
        }
        return null;
    }
}

