/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.GroovyMethodInfo;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentReferenceProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatterns;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyMethodArgumentReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(GroovyPatterns.stringLiteral(), (PsiReferenceProvider)new MyProvider());
    }

    private static class MyProvider
    extends PsiReferenceProvider {
        private MyProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            GrExpression argument = (GrExpression)element;
            PsiElement parent = element.getParent();
            if (parent instanceof GrConditionalExpression) {
                if (((GrConditionalExpression)parent).getCondition() == parent) {
                    return PsiReference.EMPTY_ARRAY;
                }
                argument = (GrConditionalExpression)parent;
                parent = parent.getParent();
            }
            if (parent instanceof GrListOrMap && !((GrListOrMap)parent).isMap()) {
                argument = (GrListOrMap)parent;
                parent = parent.getParent();
            }
            if (parent instanceof GrNamedArgument) {
                return MyProvider.createReferencesForNamedArgument(element, (GrNamedArgument)parent, context);
            }
            if (parent instanceof GrArgumentList) {
                GrArgumentList argumentList = (GrArgumentList)parent;
                int index = argumentList.getExpressionArgumentIndex(argument);
                PsiElement call = argumentList.getParent();
                if (!(call instanceof GrMethodCall)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                return PsiReference.EMPTY_ARRAY;
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static PsiReference[] createReferencesForNamedArgument(@NotNull PsiElement element, GrNamedArgument namedArgument, @NotNull ProcessingContext context) {
            String labelName = namedArgument.getLabelName();
            if (labelName == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            if (!GroovyMethodInfo.getAllSupportedNamedArguments().contains(labelName)) {
                return PsiReference.EMPTY_ARRAY;
            }
            GrCall call = PsiUtil.getCallByNamedParameter(namedArgument);
            if (!(call instanceof GrMethodCall)) {
                return PsiReference.EMPTY_ARRAY;
            }
            GrExpression invokedExpression = ((GrMethodCall)call).getInvokedExpression();
            if (!(invokedExpression instanceof GrReferenceExpression)) {
                return PsiReference.EMPTY_ARRAY;
            }
            for (GroovyResolveResult result : ((GrReferenceExpression)invokedExpression).multiResolve(false)) {
                PsiElement eMethod = result.getElement();
                if (!(eMethod instanceof PsiMethod)) continue;
                PsiMethod method = (PsiMethod)eMethod;
                for (GroovyMethodInfo info : GroovyMethodInfo.getInfos(method)) {
                    PsiReference[] refs;
                    Object referenceProvider = info.getNamedArgReferenceProvider(labelName);
                    if (referenceProvider == null || (refs = referenceProvider instanceof GroovyNamedArgumentReferenceProvider ? ((GroovyNamedArgumentReferenceProvider)referenceProvider).createRef(element, namedArgument, result, context) : ((PsiReferenceProvider)referenceProvider).getReferencesByElement(element, context)).length <= 0) continue;
                    return refs;
                }
            }
            return PsiReference.EMPTY_ARRAY;
        }
    }
}

