/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrNullVoidConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        switch (position) {
            case EXPLICIT_CAST: 
            case RETURN_VALUE: 
            case ASSIGNMENT: 
            case METHOD_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        block19: {
            block18: {
                PsiClassType objectType = TypesUtil.getJavaLangObject(context);
                if (currentPosition == GrTypeConverter.ApplicableTo.EXPLICIT_CAST) {
                    if (PsiType.VOID.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(targetType))) {
                        if (actualType.equals(objectType)) {
                            return ConversionResult.WARNING;
                        }
                        if (PsiType.VOID.equals((Object)targetType)) {
                            return PsiType.VOID.equals((Object)actualType) ? ConversionResult.OK : ConversionResult.ERROR;
                        }
                        return actualType == PsiType.NULL || PsiType.VOID.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(actualType)) ? ConversionResult.OK : ConversionResult.ERROR;
                    }
                } else if (currentPosition == GrTypeConverter.ApplicableTo.RETURN_VALUE && targetType.equals(objectType) && PsiType.VOID.equals((Object)actualType)) {
                    return ConversionResult.OK;
                }
                if (!PsiType.VOID.equals((Object)actualType)) break block18;
                switch (currentPosition) {
                    case EXPLICIT_CAST: {
                        return ConversionResult.ERROR;
                    }
                    case RETURN_VALUE: {
                        if (TypesUtil.isEnum(targetType)) {
                            return ConversionResult.OK;
                        }
                        if (targetType instanceof PsiPrimitiveType) {
                            return ConversionResult.WARNING;
                        }
                        break block19;
                    }
                    case ASSIGNMENT: {
                        if (targetType.equals(PsiType.BOOLEAN)) {
                            return null;
                        }
                        return targetType instanceof PsiPrimitiveType || TypesUtil.isEnum(targetType) ? ConversionResult.ERROR : ConversionResult.OK;
                    }
                }
                break block19;
            }
            if (actualType == PsiType.NULL) {
                switch (currentPosition) {
                    case RETURN_VALUE: {
                        if (!(targetType instanceof PsiPrimitiveType)) break;
                        return ConversionResult.WARNING;
                    }
                    default: {
                        return targetType instanceof PsiPrimitiveType ? ConversionResult.ERROR : ConversionResult.OK;
                    }
                }
            }
        }
        return null;
    }
}

