/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrClassConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        switch (position) {
            case ASSIGNMENT: 
            case RETURN_VALUE: {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        if (!(targetType instanceof PsiClassType) || !((PsiClassType)targetType).rawType().equalsToText("java.lang.Class")) {
            return null;
        }
        if (actualType == PsiType.NULL) {
            return ConversionResult.OK;
        }
        GrLiteral literal = GrClassConverter.getLiteral(context);
        Object value = literal == null ? null : literal.getValue();
        String fqn = value == null ? null : value.toString();
        PsiClass psiClass = fqn == null ? null : JavaPsiFacade.getInstance((Project)context.getProject()).findClass(fqn, context.getResolveScope());
        return psiClass == null ? ConversionResult.WARNING : ConversionResult.OK;
    }
}

