/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnonymousClassIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameIndex;

public abstract class GrTypeDefinitionElementType<TypeDef extends GrTypeDefinition>
extends GrStubElementType<GrTypeDefinitionStub, TypeDef> {
    public GrTypeDefinitionElementType(@NotNull String debugName) {
        super(debugName);
    }

    public GrTypeDefinitionStub createStub(@NotNull TypeDef psi, StubElement parentStub) {
        String[] superClassNames = psi.getSuperClassNames();
        byte flags = GrTypeDefinitionStub.buildFlags(psi);
        return new GrTypeDefinitionStub(parentStub, psi.getName(), superClassNames, this, psi.getQualifiedName(), GrStubUtils.getAnnotationNames(psi), flags);
    }

    public void serialize(@NotNull GrTypeDefinitionStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getQualifiedName());
        dataStream.writeByte((int)stub.getFlags());
        GrTypeDefinitionElementType.writeStringArray(dataStream, stub.getSuperClassNames());
        GrTypeDefinitionElementType.writeStringArray(dataStream, stub.getAnnotations());
    }

    private static void writeStringArray(StubOutputStream dataStream, String[] names) throws IOException {
        dataStream.writeByte(names.length);
        for (String name : names) {
            dataStream.writeName(name);
        }
    }

    @NotNull
    public GrTypeDefinitionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        String name = StringRef.toString((StringRef)dataStream.readName());
        String qname = StringRef.toString((StringRef)dataStream.readName());
        byte flags = dataStream.readByte();
        String[] superClasses = GrTypeDefinitionElementType.readStringArray(dataStream);
        String[] annos = GrTypeDefinitionElementType.readStringArray(dataStream);
        return new GrTypeDefinitionStub(parentStub, name, superClasses, this, qname, annos, flags);
    }

    private static String[] readStringArray(StubInputStream dataStream) throws IOException {
        int supersNumber = dataStream.readByte();
        String[] superClasses = new String[supersNumber];
        for (int i = 0; i < supersNumber; ++i) {
            superClasses[i] = StringRef.toString((StringRef)dataStream.readName());
        }
        return superClasses;
    }

    @Override
    public void indexStub(@NotNull GrTypeDefinitionStub stub, @NotNull IndexSink sink) {
        if (stub.isAnonymous()) {
            String[] classNames = stub.getSuperClassNames();
            if (classNames.length != 1) {
                return;
            }
            String baseClassName = classNames[0];
            if (baseClassName != null) {
                String shortName = PsiNameHelper.getShortClassName((String)baseClassName);
                sink.occurrence(GrAnonymousClassIndex.KEY, (Object)shortName);
            }
        } else {
            String fqn;
            String shortName = stub.getName();
            if (shortName != null) {
                sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)shortName);
            }
            if ((fqn = stub.getQualifiedName()) != null) {
                sink.occurrence(GrFullClassNameIndex.KEY, (Object)fqn.hashCode());
            }
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }
}

