/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GrParameterStub
extends StubBase<GrParameter>
implements NamedStub<GrParameter> {
    private final StringRef myName;
    private final String[] myAnnotations;
    private final String myTypeText;
    private final int myFlags;

    public GrParameterStub(StubElement parent, StringRef name, String[] annotations, String typeText, int flags) {
        super(parent, GroovyElementTypes.PARAMETER);
        this.myName = name;
        this.myAnnotations = annotations;
        this.myTypeText = typeText;
        this.myFlags = flags;
    }

    @NotNull
    public String getName() {
        return StringRef.toString((StringRef)this.myName);
    }

    public String[] getAnnotations() {
        return this.myAnnotations;
    }

    public String getTypeText() {
        return this.myTypeText;
    }

    public int getFlags() {
        return this.myFlags;
    }

    public static int encodeFlags(boolean hasInitializer, boolean isVarArgs) {
        return (hasInitializer ? 2 : 0) + (isVarArgs ? 1 : 0);
    }

    public static boolean hasInitializer(int flags) {
        return BitUtil.isSet((int)flags, (int)2);
    }

    public static boolean isVarRags(int flags) {
        return BitUtil.isSet((int)flags, (int)1);
    }
}

