/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryExpressionTypeCalculators;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryExpressionUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryFacade;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrAssignmentExpressionImpl
extends GrExpressionImpl
implements GrAssignmentExpression {
    private final GrBinaryFacade myFacade = new GrBinaryFacade(){

        @Override
        @NotNull
        public GrExpression getLeftOperand() {
            return GrAssignmentExpressionImpl.this.getLValue();
        }

        @Override
        @Nullable
        public GrExpression getRightOperand() {
            return GrAssignmentExpressionImpl.this.getRValue();
        }

        @Override
        @NotNull
        public IElementType getOperationTokenType() {
            return GrAssignmentExpressionImpl.this.getOperationTokenType();
        }

        @Override
        @NotNull
        public PsiElement getOperationToken() {
            return GrAssignmentExpressionImpl.this.getOperationToken();
        }

        @Override
        @NotNull
        public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
            return GrAssignmentExpressionImpl.this.multiResolve(false);
        }

        @Override
        @NotNull
        public GrExpression getPsiElement() {
            return GrAssignmentExpressionImpl.this;
        }
    };
    private static final ResolveCache.PolyVariantResolver<GrAssignmentExpressionImpl> RESOLVER = new ResolveCache.PolyVariantResolver<GrAssignmentExpressionImpl>(){

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull GrAssignmentExpressionImpl assignmentExpression, boolean incompleteCode) {
            IElementType opType = assignmentExpression.getOperationTokenType();
            if (opType == GroovyTokenTypes.mASSIGN) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            GrExpression lValue = assignmentExpression.getLValue();
            PsiType lType = lValue instanceof GrIndexProperty ? ((GrIndexProperty)lValue).getGetterType() : lValue.getType();
            if (lType == null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            PsiType rType = GrBinaryExpressionUtil.getRightType(assignmentExpression.getFacade());
            IElementType operatorToken = TokenSets.ASSIGNMENTS_TO_OPERATORS.get(opType);
            return TypesUtil.getOverloadedOperatorCandidates(lType, operatorToken, lValue, new PsiType[]{rType});
        }
    };
    private static final Function<GrAssignmentExpressionImpl, PsiType> TYPE_CALCULATOR = new Function<GrAssignmentExpressionImpl, PsiType>(){

        public PsiType fun(GrAssignmentExpressionImpl expression) {
            Function<GrBinaryFacade, PsiType> calculator = GrBinaryExpressionTypeCalculators.getTypeCalculator(expression.getFacade());
            return (PsiType)calculator.fun((Object)expression.getFacade());
        }
    };

    private GrBinaryFacade getFacade() {
        return this.myFacade;
    }

    public GrAssignmentExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String toString() {
        return "Assignment expression";
    }

    @Override
    @NotNull
    public GrExpression getLValue() {
        return GrAssignmentExpressionImpl.findExpressionChild(this);
    }

    @Override
    @Nullable
    public GrExpression getRValue() {
        GrExpression[] exprs = (GrExpression[])this.findChildrenByClass(GrExpression.class);
        if (exprs.length > 1) {
            return exprs[1];
        }
        return null;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        return this.getOperationToken().getNode().getElementType();
    }

    @Override
    @NotNull
    public PsiElement getOperationToken() {
        return this.findNotNullChildByType(TokenSets.ASSIGN_OP_SET);
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPE_CALCULATOR);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAssignmentExpression(this);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        return TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, RESOLVER);
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement token = this.getOperationToken();
        int offset = token.getStartOffsetInParent();
        return new TextRange(offset, offset + token.getTextLength());
    }

    public PsiElement resolve() {
        return PsiImplUtil.extractUniqueElement(this.multiResolve(false));
    }

    @NotNull
    public String getCanonicalText() {
        return this.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException("assignment expression cannot be renamed");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException("assignment expression cannot be bound to anything");
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiReference getReference() {
        IElementType operationToken = this.getOperationTokenType();
        if (operationToken == GroovyTokenTypes.mASSIGN) {
            return null;
        }
        return this;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (!ResolveUtil.shouldProcessProperties(classHint)) {
            return true;
        }
        if (!(this.getParent() instanceof GroovyFileImpl)) {
            return true;
        }
        GroovyFileImpl file = (GroovyFileImpl)this.getParent();
        if (!file.isInScriptBody(lastParent, place)) {
            return true;
        }
        GrExpression lValue = this.getLValue();
        if (!GrAssignmentExpressionImpl.processLValue(processor, state, place, file, lValue)) {
            return false;
        }
        if (lValue instanceof GrTupleExpression) {
            for (GrExpression expression : ((GrTupleExpression)lValue).getExpressions()) {
                if (GrAssignmentExpressionImpl.processLValue(processor, state, place, file, expression)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processLValue(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @NotNull GroovyFileImpl file, @NotNull GrExpression lValue) {
        if (!(lValue instanceof GrReferenceExpression)) {
            return true;
        }
        GrReferenceExpression lReference = (GrReferenceExpression)lValue;
        if (lReference.isQualified()) {
            return true;
        }
        if (lReference != place && lReference.resolve() != null && !(lReference.resolve() instanceof GrBindingVariable)) {
            return true;
        }
        String name = lReference.getReferenceName();
        if (name == null) {
            return true;
        }
        String hintName = ResolveUtil.getNameHint(processor);
        if (hintName != null && !name.equals(hintName)) {
            return true;
        }
        ConcurrentMap<String, GrBindingVariable> bindings = file.getBindings();
        GrBindingVariable variable = (GrBindingVariable)bindings.get(name);
        if (variable == null) {
            variable = (GrBindingVariable)ConcurrencyUtil.cacheOrGet(bindings, (Object)name, (Object)new GrBindingVariable(file, name, true));
        }
        if (!variable.hasWriteAccess()) {
            return true;
        }
        return processor.execute((PsiElement)variable, state);
    }
}

