/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;

public class GrDelegatesToUtil {
    @Nullable
    public static DelegatesToInfo getDelegatesToInfo(@NotNull PsiElement place, @NotNull GrClosableBlock closableBlock) {
        GrCall call = GrDelegatesToUtil.getContainingCall(closableBlock);
        if (call == null) {
            return null;
        }
        GroovyResolveResult result = call.advancedResolve();
        if (GdkMethodUtil.isWithOrIdentity(result.getElement())) {
            GrExpression qualifier = GrDelegatesToUtil.inferCallQualifier((GrMethodCall)call);
            if (qualifier == null) {
                return null;
            }
            return new DelegatesToInfo(qualifier.getType(), 1);
        }
        GrClosureSignature signature = GrDelegatesToUtil.inferSignature(result.getElement());
        if (signature == null) {
            return null;
        }
        GrClosureSignatureUtil.ArgInfo<PsiElement>[] map = GrDelegatesToUtil.mapArgs(place, call, signature);
        if (map == null) {
            return null;
        }
        PsiParameter parameter = GrDelegatesToUtil.findParameter(closableBlock, map, result);
        if (parameter == null) {
            return null;
        }
        PsiModifierList modifierList = parameter.getModifierList();
        if (modifierList == null) {
            return null;
        }
        PsiAnnotation delegatesTo = modifierList.findAnnotation("groovy.lang.DelegatesTo");
        if (delegatesTo == null) {
            return null;
        }
        PsiType type = GrDelegatesToUtil.inferDelegateType(delegatesTo, signature, map);
        if (type == null) {
            return null;
        }
        int strategyValue = GrDelegatesToUtil.getStrategyValue(delegatesTo.findAttributeValue("strategy"));
        return new DelegatesToInfo(type, strategyValue);
    }

    private static GrClosureSignatureUtil.ArgInfo<PsiElement>[] mapArgs(PsiElement place, GrCall call, GrClosureSignature signature) {
        GrClosureSignature rawSignature = GrClosureSignatureUtil.rawSignature(signature);
        return GrClosureSignatureUtil.mapParametersToArguments(rawSignature, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), place, false, false);
    }

    @Nullable
    private static GrClosureSignature inferSignature(@Nullable PsiElement element) {
        GrSignature signature;
        PsiType type;
        if (element instanceof PsiMethod) {
            return GrClosureSignatureUtil.createSignature((PsiMethod)element, PsiSubstitutor.EMPTY);
        }
        if (element instanceof GrVariable && (type = ((GrVariable)element).getTypeGroovy()) instanceof GrClosureType && (signature = ((GrClosureType)type).getSignature()) instanceof GrClosureSignature) {
            return (GrClosureSignature)signature;
        }
        return null;
    }

    @Nullable
    private static PsiParameter findParameter(@NotNull GrClosableBlock closableBlock, @NotNull GrClosureSignatureUtil.ArgInfo<PsiElement>[] map, @NotNull GroovyResolveResult result) {
        PsiElement element = result.getElement();
        if (element instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)element).getParameterList().getParameters();
            for (int i = 0; i < map.length; ++i) {
                if (!map[i].args.contains(closableBlock)) continue;
                return parameters[i];
            }
        }
        return null;
    }

    @Nullable
    private static PsiType inferDelegateType(@NotNull PsiAnnotation delegatesTo, @NotNull GrClosureSignature signature, @NotNull GrClosureSignatureUtil.ArgInfo<PsiElement>[] map) {
        PsiAnnotationMemberValue value = delegatesTo.findDeclaredAttributeValue("value");
        if (value instanceof GrReferenceExpression) {
            return GrDelegatesToUtil.extractTypeFromClassType(((GrReferenceExpression)value).getType());
        }
        if (value instanceof PsiClassObjectAccessExpression) {
            return GrDelegatesToUtil.extractTypeFromClassType(((PsiClassObjectAccessExpression)value).getType());
        }
        if (value == null || value instanceof PsiLiteralExpression && ((PsiLiteralExpression)value).getType() == PsiType.NULL || value instanceof GrLiteral && ((GrLiteral)value).getType() == PsiType.NULL) {
            String target = GrAnnotationUtil.inferStringAttribute(delegatesTo, "target");
            if (target == null) {
                return null;
            }
            int parameter = GrDelegatesToUtil.findTargetParameter(delegatesTo, target);
            if (parameter >= 0) {
                PsiType type = map[parameter].type;
                Integer index = GrAnnotationUtil.inferIntegerAttribute(delegatesTo, "genericTypeIndex");
                if (index != null) {
                    return GrDelegatesToUtil.inferGenericArgType(signature, type, index, parameter);
                }
                return type;
            }
        } else if (value instanceof PsiExpression) {
            return ((PsiExpression)value).getType();
        }
        return null;
    }

    @Nullable
    private static PsiType inferGenericArgType(@NotNull GrClosureSignature signature, @NotNull PsiType targetType, int genericIndex, int param) {
        PsiClassType.ClassResolveResult result;
        PsiClass psiClass;
        if (targetType instanceof PsiClassType && (psiClass = (result = ((PsiClassType)targetType).resolveGenerics()).getElement()) != null) {
            PsiTypeParameter[] typeParameters;
            PsiSubstitutor substitutor = result.getSubstitutor();
            PsiType baseType = signature.getParameters()[param].getType();
            PsiClass baseClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)baseType);
            if (baseClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)baseClass, (boolean)true) && genericIndex < (typeParameters = baseClass.getTypeParameters()).length) {
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)psiClass, (PsiSubstitutor)substitutor);
                return superClassSubstitutor.substitute(typeParameters[genericIndex]);
            }
        }
        return null;
    }

    private static int findTargetParameter(@NotNull PsiAnnotation delegatesTo, @NotNull String target) {
        PsiParameterList list = (PsiParameterList)delegatesTo.getParent().getParent().getParent();
        PsiParameter[] parameters = list.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            String value;
            PsiAnnotation targetAnnotation;
            PsiModifierList modifierList = parameters[i].getModifierList();
            if (modifierList == null || (targetAnnotation = modifierList.findAnnotation("groovy.lang.DelegatesTo.Target")) == null || (value = GrAnnotationUtil.inferStringAttribute(targetAnnotation, "value")) == null || !value.equals(target)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static GrExpression inferCallQualifier(@NotNull GrMethodCall call) {
        GrExpression expression = call.getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            return null;
        }
        return (GrExpression)((GrReferenceExpression)expression).getQualifier();
    }

    @Nullable
    private static PsiType extractTypeFromClassType(@Nullable PsiType type) {
        PsiType[] parameters;
        PsiClass resolved;
        if (type instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) != null && "java.lang.Class".equals(resolved.getQualifiedName()) && (parameters = ((PsiClassType)type).getParameters()).length == 1) {
            return parameters[0];
        }
        return null;
    }

    private static int getStrategyValue(@Nullable PsiAnnotationMemberValue strategy) {
        if (strategy == null) {
            return -1;
        }
        String text = strategy.getText();
        if ("0".equals(text)) {
            return 0;
        }
        if ("1".equals(text)) {
            return 1;
        }
        if ("2".equals(text)) {
            return 2;
        }
        if ("3".equals(text)) {
            return 3;
        }
        if ("4".equals(text)) {
            return 4;
        }
        if (text.endsWith("OWNER_FIRST")) {
            return 0;
        }
        if (text.endsWith("DELEGATE_FIRST")) {
            return 1;
        }
        if (text.endsWith("OWNER_ONLY")) {
            return 2;
        }
        if (text.endsWith("DELEGATE_ONLY")) {
            return 3;
        }
        if (text.endsWith("TO_SELF")) {
            return 4;
        }
        return -1;
    }

    @Nullable
    static GrCall getContainingCall(@NotNull GrClosableBlock closableBlock) {
        PsiElement parent1;
        PsiElement parent = closableBlock.getParent();
        if (parent instanceof GrCall && ArrayUtil.contains((Object)closableBlock, (Object[])((GrCall)parent).getClosureArguments())) {
            return (GrCall)parent;
        }
        if (parent instanceof GrArgumentList && (parent1 = parent.getParent()) instanceof GrCall) {
            return (GrCall)parent1;
        }
        return null;
    }

    public static class DelegatesToInfo {
        final PsiType myClassToDelegate;
        final int myStrategy;

        private DelegatesToInfo(@Nullable PsiType classToDelegate, int strategy) {
            this.myClassToDelegate = classToDelegate;
            this.myStrategy = strategy;
        }

        public PsiType getTypeToDelegate() {
            return this.myClassToDelegate;
        }

        public int getStrategy() {
            return this.myStrategy;
        }
    }
}

