/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrAnnotationStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrAnnotationImpl
extends GrStubElementBase<GrAnnotationStub>
implements GrAnnotation,
StubBasedPsiElement<GrAnnotationStub> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation.GrAnnotationImpl");
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = new PairFunction<Project, String, PsiAnnotation>(){

        public PsiAnnotation fun(Project project, String text) {
            return GroovyPsiElementFactory.getInstance(project).createAnnotationFromText(text);
        }
    };

    public GrAnnotationImpl(@NotNull ASTNode node) {
        super(node);
    }

    public GrAnnotationImpl(GrAnnotationStub stub) {
        super(stub, GroovyElementTypes.ANNOTATION);
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByStub();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAnnotation(this);
    }

    public String toString() {
        return "Annotation";
    }

    @Override
    @NotNull
    public GrAnnotationArgumentList getParameterList() {
        return (GrAnnotationArgumentList)this.findNotNullChildByClass(GrAnnotationArgumentList.class);
    }

    @Nullable
    @NonNls
    public String getQualifiedName() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            return stub.getPsiElement().getQualifiedName();
        }
        GrCodeReferenceElement nameRef = this.getClassReference();
        PsiElement resolved = nameRef.resolve();
        if (resolved instanceof PsiClass) {
            return ((PsiClass)resolved).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        GroovyResolveResult resolveResult = this.resolveWithStub();
        PsiElement resolved = resolveResult.getElement();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        return new LightClassReference((PsiManager)this.getManager(), this.getClassReference().getText(), (PsiClass)resolved, resolveResult.getSubstitutor());
    }

    @NotNull
    private GroovyResolveResult resolveWithStub() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        GrCodeReferenceElement reference = stub != null ? stub.getPsiElement().getClassReference() : this.getClassReference();
        return reference.advancedResolve();
    }

    @Nullable
    public PsiAnnotationMemberValue findAttributeValue(@Nullable String attributeName) {
        GrAnnotation stubbedPsi;
        PsiAnnotationMemberValue value;
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (!(stub == null || (value = PsiImplUtil.findAttributeValue((PsiAnnotation)(stubbedPsi = stub.getPsiElement()), (String)attributeName)) != null && PsiTreeUtil.isAncestor((PsiElement)stubbedPsi, (PsiElement)value, (boolean)true))) {
            return value;
        }
        return PsiImplUtil.findAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        GrAnnotation stubbedPsi;
        PsiAnnotationMemberValue value;
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null && (value = PsiImplUtil.findDeclaredAttributeValue((PsiAnnotation)(stubbedPsi = stub.getPsiElement()), (String)attributeName)) == null) {
            return null;
        }
        return PsiImplUtil.findDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@Nullable @NonNls String attributeName, T value) {
        return (T)PsiImplUtil.setDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName, value, ANNOTATION_CREATOR);
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return null;
    }

    @Override
    @NotNull
    public GrCodeReferenceElement getClassReference() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            return stub.getPsiElement().getClassReference();
        }
        return (GrCodeReferenceElement)this.findNotNullChildByClass(GrCodeReferenceElement.class);
    }

    @Override
    @NotNull
    public String getShortName() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            return stub.getPsiElement().getShortName();
        }
        String referenceName = this.getClassReference().getReferenceName();
        assert (referenceName != null);
        return referenceName;
    }

    @Nullable
    public PsiAnnotationOwner getOwner() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiAnnotationOwner ? (PsiAnnotationOwner)parent : null;
    }

    @NotNull
    public static PsiAnnotation.TargetType[] getApplicableElementTypeFields(PsiElement owner) {
        if (owner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)owner;
            if (aClass.isAnnotationType()) {
                return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE};
            }
            if (aClass instanceof GrTypeParameter) {
                return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_PARAMETER};
            }
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE};
        }
        if (owner instanceof GrMethod) {
            if (((PsiMethod)owner).isConstructor()) {
                return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.CONSTRUCTOR};
            }
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD};
        }
        if (owner instanceof GrVariableDeclaration) {
            GrVariable[] variables = ((GrVariableDeclaration)owner).getVariables();
            if (variables.length == 0) {
                return PsiAnnotation.TargetType.EMPTY_ARRAY;
            }
            if (variables[0] instanceof GrField || ResolveUtil.isScriptField(variables[0])) {
                return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD};
            }
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.LOCAL_VARIABLE};
        }
        if (owner instanceof GrParameter) {
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER};
        }
        if (owner instanceof GrPackageDefinition) {
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE};
        }
        if (owner instanceof GrTypeElement) {
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
        }
        return PsiAnnotation.TargetType.EMPTY_ARRAY;
    }

    public static boolean isAnnotationApplicableTo(GrAnnotation annotation, PsiAnnotation.TargetType ... elementTypeFields) {
        return elementTypeFields.length == 0 || AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])elementTypeFields) != null;
    }
}

