/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class GrTupleType
extends GrLiteralClassType {
    private final VolatileNotNullLazyValue<PsiType[]> myParameters = new VolatileNotNullLazyValue<PsiType[]>(){

        @NotNull
        protected PsiType[] compute() {
            PsiType[] types = GrTupleType.this.getComponentTypes();
            if (types.length == 0) {
                return PsiType.EMPTY_ARRAY;
            }
            PsiType leastUpperBound = GrTupleType.this.getLeastUpperBound(types);
            if (leastUpperBound == PsiType.NULL) {
                return PsiClassType.EMPTY_ARRAY;
            }
            return new PsiType[]{leastUpperBound};
        }
    };
    private final VolatileNotNullLazyValue<PsiType[]> myComponents = new VolatileNotNullLazyValue<PsiType[]>(){

        @NotNull
        protected PsiType[] compute() {
            return GrTupleType.this.inferComponents();
        }
    };

    public GrTupleType(@NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade) {
        this(scope, facade, LanguageLevel.JDK_1_5);
    }

    public GrTupleType(@NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull LanguageLevel level) {
        super(level, scope, facade);
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        return "java.util.ArrayList";
    }

    @Override
    @NotNull
    public String getClassName() {
        return StringUtil.getShortName((String)this.getJavaClassName());
    }

    @NotNull
    public PsiType[] getParameters() {
        return (PsiType[])this.myParameters.getValue();
    }

    @NotNull
    public String getInternalCanonicalText() {
        PsiType[] types = this.getComponentTypes();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < types.length; ++i) {
            if (i >= 2) {
                builder.append(",...");
                break;
            }
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(GrTupleType.getInternalCanonicalText(types[i]));
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrTupleType) {
            PsiType[] componentTypes = this.getComponentTypes();
            PsiType[] otherComponents = ((GrTupleType)((Object)obj)).getComponentTypes();
            for (int i = 0; i < Math.min(componentTypes.length, otherComponents.length); ++i) {
                if (Comparing.equal((Object)componentTypes[i], (Object)otherComponents[i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type instanceof GrTupleType) {
            PsiType[] otherComponents = ((GrTupleType)type).getComponentTypes();
            PsiType[] componentTypes = this.getComponentTypes();
            for (int i = 0; i < Math.min(componentTypes.length, otherComponents.length); ++i) {
                PsiType componentType = componentTypes[i];
                PsiType otherComponent = otherComponents[i];
                if (!(otherComponent == null ? componentType != null && !TypesUtil.isClassType(componentType, "java.lang.Object") : componentType != null && !componentType.isAssignableFrom(otherComponent))) continue;
                return false;
            }
            return true;
        }
        return super.isAssignableFrom(type);
    }

    @NotNull
    public PsiType[] getComponentTypes() {
        return (PsiType[])this.myComponents.getValue();
    }

    @NotNull
    protected abstract PsiType[] inferComponents();

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        return new GrImmediateTupleType(this.getComponentTypes(), this.myFacade, this.getResolveScope());
    }
}

