/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Couple;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GrMapTypeImpl
extends GrMapType {
    private final LinkedHashMap<String, PsiType> myStringEntries;
    private final List<Couple<PsiType>> myOtherEntries;

    GrMapTypeImpl(JavaPsiFacade facade, GlobalSearchScope scope, LinkedHashMap<String, PsiType> stringEntries, List<Couple<PsiType>> otherEntries, LanguageLevel languageLevel) {
        super(facade, scope, languageLevel);
        this.myStringEntries = stringEntries;
        this.myOtherEntries = otherEntries;
    }

    @Override
    @Nullable
    public PsiType getTypeByStringKey(String key) {
        return this.myStringEntries.get(key);
    }

    @Override
    @NotNull
    public Set<String> getStringKeys() {
        return this.myStringEntries.keySet();
    }

    @Override
    @NotNull
    protected PsiType[] getAllKeyTypes() {
        HashSet<Object> result = new HashSet<Object>();
        if (!this.myStringEntries.isEmpty()) {
            result.add(GroovyPsiManager.getInstance(this.myFacade.getProject()).createTypeByFQClassName("java.lang.String", this.getResolveScope()));
        }
        for (Couple<PsiType> entry : this.myOtherEntries) {
            result.add(entry.first);
        }
        result.remove(null);
        return result.toArray(GrMapTypeImpl.createArray((int)result.size()));
    }

    @Override
    @NotNull
    protected PsiType[] getAllValueTypes() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.myStringEntries.values());
        for (Couple<PsiType> entry : this.myOtherEntries) {
            result.add(entry.second);
        }
        result.remove(null);
        return result.toArray(GrMapTypeImpl.createArray((int)result.size()));
    }

    @Override
    @NotNull
    protected List<Couple<PsiType>> getOtherEntries() {
        return this.myOtherEntries;
    }

    @Override
    @NotNull
    protected LinkedHashMap<String, PsiType> getStringEntries() {
        return this.myStringEntries;
    }

    public boolean isValid() {
        for (PsiType psiType : this.myStringEntries.values()) {
            if (psiType == null || psiType.isValid()) continue;
            return false;
        }
        for (Couple couple : this.myOtherEntries) {
            if (couple.first != null && !((PsiType)couple.first).isValid()) {
                return false;
            }
            if (couple.second == null || ((PsiType)couple.second).isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.myStringEntries.isEmpty() && this.myOtherEntries.isEmpty();
    }
}

