/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrClosureType
extends GrLiteralClassType {
    private final GrSignature mySignature;
    private volatile PsiType[] myTypeArgs = null;

    private GrClosureType(LanguageLevel languageLevel, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull GrSignature closureSignature, boolean shouldInferTypeParameters) {
        super(languageLevel, scope, facade);
        this.mySignature = closureSignature;
        if (!shouldInferTypeParameters) {
            this.myTypeArgs = PsiType.EMPTY_ARRAY;
        }
    }

    private GrClosureType(LanguageLevel level, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull GrSignature signature, @Nullable PsiType[] typeArgs) {
        super(level, scope, facade);
        this.mySignature = signature;
        this.myTypeArgs = typeArgs;
    }

    @Override
    @NotNull
    public String getClassName() {
        return "Closure";
    }

    @NotNull
    public PsiType[] getParameters() {
        if (this.myTypeArgs == null) {
            this.myTypeArgs = this.inferParameters();
        }
        return this.myTypeArgs;
    }

    @NotNull
    private PsiType[] inferParameters() {
        PsiClass psiClass = this.resolve();
        if (psiClass != null && psiClass.getTypeParameters().length == 1) {
            PsiType type = GrClosureSignatureUtil.getReturnType(this.mySignature);
            if (type == PsiType.NULL || type == null) {
                return new PsiType[]{null};
            }
            return new PsiType[]{TypesUtil.boxPrimitiveType(type, this.getPsiManager(), this.getResolveScope(), true)};
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        return "groovy.lang.Closure";
    }

    @Override
    @NotNull
    public PsiClassType rawType() {
        if (this.myTypeArgs != null && this.myTypeArgs.length == 0) {
            return this;
        }
        return new GrClosureType(this.getLanguageLevel(), this.getResolveScope(), this.myFacade, this.mySignature, false);
    }

    @NotNull
    public String getInternalCanonicalText() {
        return this.getCanonicalText();
    }

    public boolean isValid() {
        return this.mySignature.isValid();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrClosureType) {
            return Comparing.equal((Object)this.mySignature, (Object)((GrClosureType)((Object)obj)).mySignature);
        }
        return super.equals(obj);
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        return new GrClosureType(languageLevel, this.myScope, this.myFacade, this.mySignature, this.myTypeArgs);
    }

    public static GrClosureType create(GroovyResolveResult[] results, GroovyPsiElement context) {
        ArrayList<GrClosureSignature> signatures = new ArrayList<GrClosureSignature>();
        for (GroovyResolveResult result : results) {
            if (!(result.getElement() instanceof PsiMethod)) continue;
            signatures.add(GrClosureSignatureUtil.createSignature((PsiMethod)result.getElement(), result.getSubstitutor()));
        }
        GlobalSearchScope resolveScope = context.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
        if (signatures.size() == 1) {
            return GrClosureType.create((GrSignature)signatures.get(0), resolveScope, facade, LanguageLevel.JDK_1_5, true);
        }
        return GrClosureType.create(GrClosureSignatureUtil.createMultiSignature(signatures.toArray(new GrClosureSignature[signatures.size()])), resolveScope, facade, LanguageLevel.JDK_1_5, true);
    }

    public static GrClosureType create(@NotNull GrClosableBlock closure, boolean shouldInferTypeParameters) {
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(closure);
        GlobalSearchScope resolveScope = closure.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)closure.getProject());
        return GrClosureType.create(signature, resolveScope, facade, LanguageLevel.JDK_1_5, shouldInferTypeParameters);
    }

    public static GrClosureType create(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, substitutor);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)method.getProject());
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)method.getProject());
        return GrClosureType.create(signature, scope, facade, LanguageLevel.JDK_1_5, true);
    }

    public static GrClosureType create(@NotNull PsiParameter[] parameters, @Nullable PsiType returnType, JavaPsiFacade facade, GlobalSearchScope scope, LanguageLevel languageLevel) {
        return GrClosureType.create(GrClosureSignatureUtil.createSignature(parameters, returnType), scope, facade, languageLevel, true);
    }

    public static GrClosureType create(@NotNull GrSignature signature, GlobalSearchScope scope, JavaPsiFacade facade, LanguageLevel languageLevel, boolean shouldInferTypeParameters) {
        return new GrClosureType(languageLevel, scope, facade, signature, shouldInferTypeParameters);
    }

    @Nullable
    public PsiType curry(@NotNull PsiType[] args, int position, @NotNull GroovyPsiElement context) {
        GrSignature newSignature = this.mySignature.curry(args, position, context);
        if (newSignature == null) {
            return null;
        }
        return new GrClosureType(this.myLanguageLevel, this.myScope, this.myFacade, newSignature, this.myTypeArgs);
    }

    @NotNull
    public GrSignature getSignature() {
        return this.mySignature;
    }
}

