/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.expectedTypes;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class SubtypeConstraint
extends TypeConstraint {
    private final PsiType myDefaultType;

    protected SubtypeConstraint(@NotNull PsiType type, @NotNull PsiType defaultType) {
        super(type);
        this.myDefaultType = defaultType;
    }

    @Override
    public boolean satisfied(PsiType type, @NotNull PsiElement context) {
        return TypesUtil.isAssignableByMethodCallConversion(this.getType(), type, context);
    }

    @Override
    @NotNull
    public PsiType getDefaultType() {
        return this.myDefaultType;
    }

    public static SubtypeConstraint create(@NotNull PsiType type) {
        return new SubtypeConstraint(type, type);
    }

    public static SubtypeConstraint create(String fqName, PsiElement context) {
        PsiClassType type = TypesUtil.createType(fqName, context);
        return new SubtypeConstraint((PsiType)type, (PsiType)type);
    }
}

