/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class DFAType {
    private final PsiType primary;
    private final List<Mixin> mixins = new ArrayList<Mixin>();

    private DFAType(@Nullable PsiType primary) {
        this.primary = primary;
    }

    public void addMixin(@Nullable PsiType mixin, ConditionInstruction instruction) {
        if (mixin == null) {
            return;
        }
        this.mixins.add(new Mixin(mixin, instruction, false));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DFAType)) {
            return false;
        }
        DFAType other = (DFAType)obj;
        if (!DFAType.eq(this.primary, other.primary)) {
            return false;
        }
        if (this.mixins.size() != other.mixins.size()) {
            return false;
        }
        for (Mixin mixin1 : this.mixins) {
            boolean contains = false;
            for (Mixin mixin2 : other.mixins) {
                if (mixin1.ID != mixin2.ID) continue;
                contains = mixin1.myNegated == mixin2.myNegated;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    public DFAType negate(@NotNull Instruction instruction) {
        DFAType type = new DFAType(this.primary);
        for (Mixin mixin : this.mixins) {
            type.mixins.add(mixin);
        }
        for (NegatingGotoInstruction negatingGotoInstruction : instruction.getNegatingGotoInstruction()) {
            Set<ConditionInstruction> conditionsToNegate = negatingGotoInstruction.getCondition().getDependentConditions();
            ListIterator<Mixin> iterator = type.mixins.listIterator();
            while (iterator.hasNext()) {
                Mixin mixin = iterator.next();
                if (!conditionsToNegate.contains(mixin.myCondition)) continue;
                iterator.set(mixin.negate());
            }
        }
        return type;
    }

    @Nullable
    public PsiType getResultType() {
        if (this.mixins.isEmpty()) {
            return this.primary;
        }
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        if (this.primary != null) {
            types.add(this.primary);
        }
        for (Mixin mixin : this.mixins) {
            if (mixin.myNegated) continue;
            types.add(mixin.myType);
        }
        if (types.isEmpty()) {
            return null;
        }
        return PsiIntersectionType.createIntersection((PsiType[])types.toArray(PsiType.createArray((int)types.size())));
    }

    public static DFAType create(@Nullable PsiType type) {
        return new DFAType(type);
    }

    private static boolean eq(PsiType t1, PsiType t2) {
        return t1 == t2 || Comparing.equal((Object)TypeConversionUtil.erasure((PsiType)t1), (Object)TypeConversionUtil.erasure((PsiType)t2));
    }

    @Nullable
    public static DFAType create(DFAType t1, DFAType t2, PsiManager manager) {
        if (t1.equals(t2)) {
            return t1;
        }
        PsiType primary = TypesUtil.getLeastUpperBoundNullable(t1.primary, t2.primary, manager);
        DFAType type = new DFAType(primary);
        for (Mixin mixin1 : t1.mixins) {
            for (Mixin mixin2 : t2.mixins) {
                if (mixin1.ID != mixin2.ID || mixin1.myNegated != mixin2.myNegated) continue;
                type.mixins.add(mixin1);
            }
        }
        return type;
    }

    public String toString() {
        return "DFAType{primary=" + this.primary + ", mixins=" + this.mixins + '}';
    }

    private static class Mixin {
        private final int ID;
        private final PsiType myType;
        private final ConditionInstruction myCondition;
        private final boolean myNegated;

        private Mixin(PsiType type, ConditionInstruction condition, boolean negated) {
            this(-1, type, condition, negated);
        }

        private Mixin(int ID2, PsiType type, ConditionInstruction condition, boolean negated) {
            if (ID2 == -1) {
                ID2 = this.hashCode();
            }
            this.ID = ID2;
            this.myType = type;
            this.myCondition = condition;
            this.myNegated = negated;
        }

        Mixin negate() {
            return new Mixin(this.ID, this.myType, this.myCondition, !this.myNegated);
        }

        public String toString() {
            return "Mixin{ID=" + this.ID + ", myType=" + this.myType + ", myCondition=" + this.myCondition + ", myNegated=" + this.myNegated + '}';
        }
    }
}

