/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class ImportStaticIntention
extends Intention {
    private static final Key<PsiElement> TEMP_REFERENT_USER_DATA = new Key("TEMP_REFERENT_USER_DATA");

    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        final PsiElement resolved = ImportStaticIntention.resolve(element);
        if (!(resolved instanceof PsiMember)) {
            return;
        }
        PsiClass containingClass = ((PsiMember)resolved).getContainingClass();
        if (containingClass == null) {
            return;
        }
        String originalName = ((PsiMember)resolved).getName();
        final String name = resolved instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertyAccessor((PsiMethod)resolved) ? GroovyPropertyUtils.getPropertyName((PsiMethod)resolved) : originalName;
        String qname = containingClass.getQualifiedName();
        if (name == null) {
            return;
        }
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof GroovyFile)) {
            return;
        }
        GroovyFile file = (GroovyFile)containingFile;
        file.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(GrReferenceExpression expression) {
                PsiElement resolved;
                super.visitReferenceExpression(expression);
                if (name.equals(expression.getReferenceName()) && (resolved = expression.resolve()) != null) {
                    expression.putUserData(TEMP_REFERENT_USER_DATA, resolved);
                }
            }
        });
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrImportStatement tempImport = factory.createImportStatementFromText(qname + "." + name, true, false, null);
        GrImportStatement importStatement = file.addImport(tempImport);
        boolean isAnythingShortened = ImportStaticIntention.shortenUsages(resolved, containingFile);
        if (!isAnythingShortened) {
            importStatement.delete();
            return;
        }
        file.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(GrReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                GrTypeArgumentList typeArgumentList = expression.getTypeArgumentList();
                if (typeArgumentList != null && typeArgumentList.getFirstChild() != null) {
                    expression.putUserData(TEMP_REFERENT_USER_DATA, null);
                    return;
                }
                if (name.equals(expression.getReferenceName())) {
                    if (expression.isQualified()) {
                        PsiElement aClass;
                        GrExpression qualifier = expression.getQualifierExpression();
                        if (qualifier instanceof GrReferenceExpression && (aClass = ((GrReferenceExpression)qualifier).resolve()) == ((PsiMember)resolved).getContainingClass()) {
                            GrReferenceAdjuster.shortenReference(expression);
                        }
                    } else {
                        PsiElement referent = (PsiElement)expression.getUserData(TEMP_REFERENT_USER_DATA);
                        if (referent instanceof PsiMember && ((PsiMember)referent).hasModifierProperty("static") && referent != expression.resolve()) {
                            expression.bindToElement(referent);
                        }
                    }
                }
                expression.putUserData(TEMP_REFERENT_USER_DATA, null);
            }
        });
    }

    private static boolean shortenUsages(PsiElement resolved, PsiFile containingFile) {
        boolean isAnythingShortened = false;
        for (PsiReference reference : ReferencesSearch.search((PsiElement)resolved, (SearchScope)new LocalSearchScope((PsiElement)containingFile))) {
            PsiElement refElement = reference.getElement();
            if (!(refElement instanceof GrQualifiedReference)) continue;
            boolean shortened = GrReferenceAdjuster.shortenReference((GrQualifiedReference)refElement);
            isAnythingShortened |= shortened;
        }
        return isAnythingShortened;
    }

    @Override
    protected boolean isStopElement(PsiElement element) {
        return super.isStopElement(element) || element instanceof GrReferenceExpression;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiElement resolved = ImportStaticIntention.resolve(element);
                if (resolved == null) {
                    return false;
                }
                return resolved instanceof PsiMember && !(resolved instanceof PsiClass) && ((PsiMember)resolved).hasModifierProperty("static") && ((PsiMember)resolved).getContainingClass() != null;
            }
        };
    }

    @Nullable
    private static PsiElement resolve(PsiElement element) {
        GrReferenceExpression ref = ImportStaticIntention.findRef(element);
        if (ref == null || ref.getQualifier() == null) {
            return null;
        }
        return ref.resolve();
    }

    @Nullable
    private static GrReferenceExpression findRef(PsiElement element) {
        GrExpression invoked;
        PsiElement parent;
        if (element instanceof GrReferenceExpression) {
            return (GrReferenceExpression)element;
        }
        if (element instanceof GrArgumentList && (parent = element.getParent()) instanceof GrMethodCall && (invoked = ((GrMethodCall)parent).getInvokedExpression()) instanceof GrReferenceExpression) {
            return (GrReferenceExpression)invoked;
        }
        return null;
    }
}

