/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.other;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import groovy.lang.Closure;
import java.util.Arrays;
import java.util.Comparator;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

public class GrSortMapKeysIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        GrNamedArgument[] namedArgs;
        GrListOrMap map;
        PsiElement pparent;
        PsiElement parent = element.getParent();
        if (parent instanceof GrArgumentLabel && (pparent = parent.getParent().getParent()) instanceof GrListOrMap && !ErrorUtil.containsError(pparent) && (map = (GrListOrMap)pparent).getInitializers().length == 0 && GrSortMapKeysIntention.isLiteralKeys(namedArgs = map.getNamedArguments())) {
            GrListOrMap newMap = GrSortMapKeysIntention.constructNewMap(namedArgs, project);
            map.replace(newMap);
        }
    }

    @NotNull
    private static GrListOrMap constructNewMap(@NotNull GrNamedArgument[] args, Project project) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Arrays.sort(args, new Comparator<GrNamedArgument>(){

            @Override
            public int compare(GrNamedArgument o1, GrNamedArgument o2) {
                String l1 = o1.getLabelName();
                String l2 = o2.getLabelName();
                assert (l1 != null && l2 != null);
                return l1.compareTo(l2);
            }
        });
        for (GrNamedArgument arg : args) {
            builder.append(arg.getText()).append(",\n");
        }
        builder.replace(builder.length() - 2, builder.length(), "]");
        return (GrListOrMap)GroovyPsiElementFactory.getInstance(project).createExpressionFromText(builder);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                GrListOrMap map;
                PsiElement parent = element.getParent();
                return parent instanceof GrArgumentLabel && ((GrArgumentLabel)parent).getNameElement().equals(element) && parent.getParent() != null && parent.getParent().getParent() instanceof GrListOrMap && !ErrorUtil.containsError(map = (GrListOrMap)DefaultGroovyMethods.asType((Object)parent.getParent().getParent(), GrListOrMap.class)) && map.getInitializers().length == 0 && GrSortMapKeysIntention.isLiteralKeys(map.getNamedArguments());
            }
        };
    }

    private static boolean isLiteralKeys(GrNamedArgument[] args) {
        return DefaultGroovyMethods.find((Object[])args, (Closure)new Closure<Boolean>(null, null){

            public Boolean doCall(GrNamedArgument it) {
                return it.getLabel().getNameElement() == null;
            }

            public Boolean doCall() {
                return this.doCall(null);
            }
        }) == null;
    }
}

