/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;

public class SimplifyTernaryOperatorIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (!(element instanceof GrConditionalExpression)) {
            throw new IncorrectOperationException("Not invoked on a conditional");
        }
        GrConditionalExpression condExp = (GrConditionalExpression)element;
        GrExpression thenBranch = condExp.getThenBranch();
        GrExpression elseBranch = condExp.getElseBranch();
        Object thenVal = GroovyConstantExpressionEvaluator.evaluate(thenBranch);
        if (Boolean.TRUE.equals(thenVal) && elseBranch != null) {
            GrExpression conditionExp = condExp.getCondition();
            String conditionExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoOrExpression(conditionExp);
            String elseExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoOrExpression(elseBranch);
            String newExp = conditionExpText + "||" + elseExpText;
            SimplifyTernaryOperatorIntention.manageReplace(editor, condExp, conditionExpText, newExp);
            return;
        }
        Object elseVal = GroovyConstantExpressionEvaluator.evaluate(elseBranch);
        if (Boolean.FALSE.equals(elseVal) && thenBranch != null) {
            GrExpression conditionExp = condExp.getCondition();
            String conditionExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoAndExpression(conditionExp);
            String thenExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoAndExpression(thenBranch);
            String newExp = conditionExpText + "&&" + thenExpText;
            SimplifyTernaryOperatorIntention.manageReplace(editor, condExp, conditionExpText, newExp);
        }
    }

    private static void manageReplace(Editor editor, GrConditionalExpression condExp, String conditionExpText, String newExp) {
        int caretOffset = conditionExpText.length() + 2;
        GrExpression expressionFromText = GroovyPsiElementFactory.getInstance(editor.getProject()).createExpressionFromText(newExp, condExp.getContext());
        expressionFromText = (GrExpression)condExp.replace(expressionFromText);
        editor.getCaretModel().moveToOffset(expressionFromText.getTextOffset() + caretOffset);
    }

    @NotNull
    private static String getStringToPutIntoAndExpression(GrExpression expression) {
        String expressionText = expression.getText();
        if (ParenthesesUtils.AND_PRECEDENCE < ParenthesesUtils.getPrecedence(expression)) {
            expressionText = "(" + expressionText + ")";
        }
        return expressionText;
    }

    @NotNull
    private static String getStringToPutIntoOrExpression(GrExpression expression) {
        String expressionText = expression.getText();
        if (ParenthesesUtils.OR_PRECEDENCE < ParenthesesUtils.getPrecedence(expression)) {
            expressionText = "(" + expressionText + ")";
        }
        return expressionText;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof GrConditionalExpression)) {
                    return false;
                }
                GrConditionalExpression condExp = (GrConditionalExpression)element;
                PsiType condType = condExp.getType();
                if (condType == null || !PsiType.BOOLEAN.isConvertibleFrom(condType)) {
                    return false;
                }
                GrExpression thenBranch = condExp.getThenBranch();
                GrExpression elseBranch = condExp.getElseBranch();
                Object thenVal = GroovyConstantExpressionEvaluator.evaluate(thenBranch);
                if (Boolean.TRUE.equals(thenVal) && elseBranch != null) {
                    return true;
                }
                Object elseVal = GroovyConstantExpressionEvaluator.evaluate(elseBranch);
                return thenBranch != null && Boolean.FALSE.equals(elseVal);
            }
        };
    }
}

