/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;

public class GroovyBraceEnforcer
extends GroovyRecursiveElementVisitor {
    private static final Logger LOG = Logger.getInstance(GroovyBraceEnforcer.class);
    private final PostFormatProcessorHelper myPostProcessor;

    public GroovyBraceEnforcer(CodeStyleSettings settings) {
        this.myPostProcessor = new PostFormatProcessorHelper(settings.getCommonSettings((Language)GroovyLanguage.INSTANCE));
    }

    public TextRange processText(GroovyFile source, TextRange rangeToReformat) {
        this.myPostProcessor.setResultTextRange(rangeToReformat);
        source.accept(this);
        return this.myPostProcessor.getResultTextRange();
    }

    public PsiElement process(GroovyPsiElement formatted) {
        LOG.assertTrue(formatted.isValid());
        formatted.accept(this);
        return formatted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceWithBlock(@NotNull GrStatement statement, GrStatement blockCandidate) {
        if (!statement.isValid()) {
            LOG.assertTrue(false);
        }
        if (!this.checkRangeContainsElement(blockCandidate)) {
            return;
        }
        PsiManager manager = statement.getManager();
        LOG.assertTrue(manager != null);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(manager.getProject());
        String oldText = blockCandidate.getText();
        StringBuilder buf = new StringBuilder(oldText.length() + 5);
        buf.append("{\n").append(oldText);
        buf.append("\n}");
        int oldTextLength = statement.getTextLength();
        try {
            ASTNode newChild = SourceTreeToPsiMap.psiElementToTree((PsiElement)factory.createBlockStatementFromText(buf.toString(), null));
            ASTNode parent = SourceTreeToPsiMap.psiElementToTree((PsiElement)statement);
            ASTNode childToReplace = SourceTreeToPsiMap.psiElementToTree((PsiElement)blockCandidate);
            CodeEditUtil.replaceChild((ASTNode)parent, (ASTNode)childToReplace, (ASTNode)newChild);
            GroovyBraceEnforcer.removeTailSemicolon(newChild, parent);
            CodeStyleManager.getInstance((Project)statement.getProject()).reformat((PsiElement)statement, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.updateResultRange(oldTextLength, statement.getTextLength());
        }
    }

    private static void removeTailSemicolon(ASTNode newChild, ASTNode parent) {
        ASTNode semi;
        for (semi = newChild.getTreeNext(); semi != null && semi.getElementType() == TokenType.WHITE_SPACE && !semi.getText().contains("\n"); semi = semi.getTreeNext()) {
        }
        if (semi != null && semi.getElementType() == GroovyTokenTypes.mSEMI) {
            parent.removeRange(newChild.getTreeNext(), semi.getTreeNext());
        }
    }

    protected void updateResultRange(int oldTextLength, int newTextLength) {
        this.myPostProcessor.updateResultRange(oldTextLength, newTextLength);
    }

    protected boolean checkElementContainsRange(PsiElement element) {
        return this.myPostProcessor.isElementPartlyInRange(element);
    }

    protected boolean checkRangeContainsElement(PsiElement element) {
        return this.myPostProcessor.isElementFullyInRange(element);
    }

    private void processStatement(GrStatement statement, @Nullable GrStatement blockCandidate, int options) {
        if (blockCandidate instanceof GrCodeBlock || blockCandidate instanceof GrBlockStatement || blockCandidate == null) {
            return;
        }
        if (options == 3 || options == 1 && PostFormatProcessorHelper.isMultiline((PsiElement)statement)) {
            this.replaceWithBlock(statement, blockCandidate);
        }
    }

    @Override
    public void visitIfStatement(GrIfStatement statement) {
        if (this.checkElementContainsRange(statement)) {
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)statement.getProject()).createSmartPsiElementPointer((PsiElement)statement);
            super.visitIfStatement(statement);
            statement = (GrIfStatement)pointer.getElement();
            if (statement == null) {
                return;
            }
            this.processStatement(statement, statement.getThenBranch(), this.myPostProcessor.getSettings().IF_BRACE_FORCE);
            GrStatement elseBranch = statement.getElseBranch();
            if (!(elseBranch instanceof GrIfStatement) || !this.myPostProcessor.getSettings().SPECIAL_ELSE_IF_TREATMENT) {
                this.processStatement(statement, elseBranch, this.myPostProcessor.getSettings().IF_BRACE_FORCE);
            }
        }
    }

    @Override
    public void visitForStatement(GrForStatement statement) {
        if (this.checkElementContainsRange(statement)) {
            super.visitForStatement(statement);
            this.processStatement(statement, statement.getBody(), this.myPostProcessor.getSettings().FOR_BRACE_FORCE);
        }
    }

    @Override
    public void visitWhileStatement(GrWhileStatement statement) {
        if (this.checkElementContainsRange(statement)) {
            super.visitWhileStatement(statement);
            this.processStatement(statement, statement.getBody(), this.myPostProcessor.getSettings().WHILE_BRACE_FORCE);
        }
    }
}

