/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class LiteralConstructorReference
extends PsiReferenceBase.Poly<GrListOrMap> {
    public LiteralConstructorReference(@NotNull GrListOrMap element) {
        super((PsiElement)element, TextRange.from((int)0, (int)0), false);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.getElement();
    }

    @Nullable
    public PsiClassType getConstructedClassType() {
        return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)this.getElement(), (CachedValueProvider)new CachedValueProvider<PsiClassType>(){

            @Nullable
            public CachedValueProvider.Result<PsiClassType> compute() {
                return CachedValueProvider.Result.create((Object)LiteralConstructorReference.this.inferConversionType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    @Nullable
    private PsiClassType inferConversionType() {
        PsiType ownType;
        PsiType unboxed;
        GrListOrMap listOrMap = (GrListOrMap)this.getElement();
        PsiClassType conversionType = LiteralConstructorReference.getTargetConversionType(listOrMap);
        if (conversionType == null) {
            return null;
        }
        if (listOrMap.isEmpty() && (PsiType.BOOLEAN.equals((Object)(unboxed = TypesUtil.unboxPrimitiveTypeWrapper((PsiType)conversionType))) || PsiType.CHAR.equals((Object)unboxed))) {
            return null;
        }
        PsiType type = listOrMap.getType();
        Object object = ownType = type instanceof PsiClassType ? ((PsiClassType)type).rawType() : type;
        if (ownType != null && TypesUtil.isAssignableWithoutConversions((PsiType)conversionType.rawType(), ownType, listOrMap)) {
            return null;
        }
        PsiClass resolved = conversionType.resolve();
        if (resolved != null) {
            if (InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.Set")) {
                return null;
            }
            if (InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.List")) {
                return null;
            }
        }
        return conversionType;
    }

    @Nullable
    public static PsiClassType getTargetConversionType(@NotNull GrExpression expression) {
        PsiElement parent = PsiUtil.skipParentheses(expression.getParent(), true);
        PsiType type = null;
        if (parent instanceof GrSafeCastExpression) {
            type = ((GrSafeCastExpression)parent).getType();
        } else if (parent instanceof GrAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((GrAssignmentExpression)parent).getRValue(), (PsiElement)expression, (boolean)false)) {
            PsiElement lValue = PsiUtil.skipParentheses(((GrAssignmentExpression)parent).getLValue(), false);
            if (lValue instanceof GrReferenceExpression) {
                type = ((GrReferenceExpression)lValue).getNominalType();
            }
        } else if (parent instanceof GrVariable) {
            type = ((GrVariable)parent).getDeclaredType();
        } else if (parent instanceof GrNamedArgument) {
            for (PsiType expected : GroovyExpectedTypesProvider.getDefaultExpectedTypes(expression)) {
                if ((expected = LiteralConstructorReference.filterOutTrashTypes(expected)) == null) continue;
                return (PsiClassType)expected;
            }
        } else {
            GrControlFlowOwner controlFlowOwner = ControlFlowUtils.findControlFlowOwner(expression);
            if (controlFlowOwner instanceof GrOpenBlock && controlFlowOwner.getParent() instanceof GrMethod && ControlFlowUtils.isReturnValue(expression, controlFlowOwner) && (PsiType.BOOLEAN.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(type = ((GrMethod)controlFlowOwner.getParent()).getReturnType())) || TypesUtil.isEnum(type) || PsiUtil.isCompileStatic(expression) || TypesUtil.isClassType(type, "java.lang.String") || TypesUtil.isClassType(type, "java.lang.Class"))) {
                type = null;
            }
        }
        if (PsiType.BOOLEAN.equals((Object)type)) {
            type = TypesUtil.boxPrimitiveType(type, expression.getManager(), expression.getResolveScope());
        }
        return LiteralConstructorReference.filterOutTrashTypes(type);
    }

    @Nullable
    private static PsiClassType filterOutTrashTypes(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        if (type.equalsToText("java.lang.Object")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type, "java.util.Map")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type, "java.util.HashMap")) {
            return null;
        }
        if (TypesUtil.resolvesTo(type, "java.util.List")) {
            return null;
        }
        PsiType erased = TypeConversionUtil.erasure((PsiType)type);
        if (erased == null || erased.equalsToText("java.lang.Object")) {
            return null;
        }
        return (PsiClassType)type;
    }

    @NotNull
    public GrExpression[] getCallArguments() {
        GrListOrMap literal = (GrListOrMap)this.getElement();
        if (literal.isMap()) {
            GrNamedArgument argument = literal.findNamedArgument("super");
            if (argument != null) {
                GrExpression expression = argument.getExpression();
                if (expression instanceof GrListOrMap && !((GrListOrMap)expression).isMap()) {
                    return ((GrListOrMap)expression).getInitializers();
                }
                if (expression != null) {
                    return new GrExpression[]{expression};
                }
                return GrExpression.EMPTY_ARRAY;
            }
            return new GrExpression[]{literal};
        }
        return literal.getInitializers();
    }

    @NotNull
    private PsiType[] getCallArgumentTypes() {
        Object[] arguments = this.getCallArguments();
        return (PsiType[])ContainerUtil.map2Array((Object[])arguments, PsiType.class, (Function)new NullableFunction<GrExpression, PsiType>(){

            public PsiType fun(GrExpression grExpression) {
                return grExpression.getType();
            }
        });
    }

    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult result;
        PsiClassType type = this.getConstructedClassType();
        if (type == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        PsiClassType.ClassResolveResult classResolveResult = type.resolveGenerics();
        GroovyResolveResult[] constructorCandidates = PsiUtil.getConstructorCandidates(type, this.getCallArgumentTypes(), (GroovyPsiElement)this.getElement());
        if (constructorCandidates.length == 0 && (result = GroovyResolveResultImpl.from(classResolveResult)) != GroovyResolveResult.EMPTY_RESULT) {
            return new GroovyResolveResult[]{result};
        }
        return constructorCandidates;
    }

    @NotNull
    public Object[] getVariants() {
        return EMPTY_ARRAY;
    }
}

