/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class AccessorMethodReferencesSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public AccessorMethodReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        String propertyName;
        PsiMethod method = queryParameters.getMethod();
        if (GdkMethodUtil.isCategoryMethod(method, null, null, PsiSubstitutor.EMPTY)) {
            GrGdkMethod cat = GrGdkMethodImpl.createGdkMethod(method, false, null);
            propertyName = GroovyPropertyUtils.getPropertyName(cat);
        } else {
            propertyName = GroovyPropertyUtils.getPropertyName(method);
        }
        if (propertyName == null) {
            return;
        }
        SearchScope onlyGroovyFiles = GroovyScopeUtil.restrictScopeToGroovyFiles(queryParameters.getEffectiveSearchScope(), GroovyScopeUtil.getEffectiveScope(method));
        queryParameters.getOptimizer().searchWord(propertyName, onlyGroovyFiles, (short)1, true, (PsiElement)method);
        if (!GroovyPropertyUtils.isPropertyName(propertyName)) {
            queryParameters.getOptimizer().searchWord(StringUtil.decapitalize((String)propertyName), onlyGroovyFiles, (short)1, true, (PsiElement)method);
        }
    }
}

