/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.search.GlobalSearchScope;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public abstract class GroovyScriptTypeDetector {
    public static final ExtensionPointName<GroovyScriptTypeDetector> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.scriptTypeDetector");
    private final GroovyScriptType myScriptType;
    private final String[] myExtensions;

    protected GroovyScriptTypeDetector(GroovyScriptType scriptType, String ... extensions) {
        this.myScriptType = scriptType;
        this.myExtensions = extensions;
    }

    @NotNull
    public final String[] getExtensions() {
        return this.myExtensions;
    }

    @NotNull
    public final GroovyScriptType getScriptType() {
        return this.myScriptType;
    }

    public abstract boolean isSpecificScriptFile(@NotNull GroovyFile var1);

    @NotNull
    public static Icon getIcon(@NotNull GroovyFile script) {
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(script)) continue;
            return detector.getScriptType().getScriptIcon();
        }
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    public static GlobalSearchScope patchResolveScope(@NotNull GroovyFile script, GlobalSearchScope scope) {
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(script)) continue;
            return detector.getScriptType().patchResolveScope(script, scope);
        }
        return scope;
    }
}

