/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.console.GroovyConsole;
import org.jetbrains.plugins.groovy.console.GroovyConsoleStateService;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtil;

public class GrSelectModuleAction
extends AnAction {
    private final GroovyConsoleStateService myProjectConsole;
    private final VirtualFile myFile;

    public GrSelectModuleAction(GroovyConsoleStateService console, VirtualFile file) {
        super(null, "Which module to use classpath of?", AllIcons.Nodes.Module);
        this.myProjectConsole = console;
        this.myFile = file;
    }

    public boolean displayTextInToolbar() {
        return super.displayTextInToolbar();
    }

    public void update(AnActionEvent e) {
        if (this.myProjectConsole.isProjectConsole(this.myFile)) {
            Module module = this.myProjectConsole.getSelectedModule(this.myFile);
            e.getPresentation().setText(GrSelectModuleAction.getText(module));
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    @NotNull
    public static String getText(@Nullable Module module) {
        return module == null || module.isDisposed() ? "Select module..." : GroovyConsoleUtil.getTitle(module);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        GroovyConsoleUtil.selectModuleAndRun(project, new Consumer<Module>(){

            public void consume(Module module) {
                Module existingModule = GrSelectModuleAction.this.myProjectConsole.getSelectedModule(GrSelectModuleAction.this.myFile);
                if (module.equals(existingModule)) {
                    return;
                }
                GroovyConsole existingConsole = (GroovyConsole)GrSelectModuleAction.this.myFile.getUserData(GroovyConsole.GROOVY_CONSOLE);
                if (existingConsole != null) {
                    existingConsole.stop();
                }
                GrSelectModuleAction.this.myProjectConsole.setFileModule(GrSelectModuleAction.this.myFile, module);
                GrSelectModuleAction.this.myFile.putUserData(GroovyConsole.GROOVY_CONSOLE, null);
                ProjectView.getInstance((Project)project).refresh();
            }
        }, e.getDataContext());
    }
}

