/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtil;

@State(name="GroovyConsoleState", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GroovyConsoleStateService
implements PersistentStateComponent<MyState> {
    private final ModuleManager myModuleManager;
    private final VirtualFileManager myFileManager;
    private final Map<VirtualFile, Pair<Module, String>> myFileModuleMap = Collections.synchronizedMap(ContainerUtil.newHashMap());

    public GroovyConsoleStateService(ModuleManager manager, VirtualFileManager fileManager) {
        this.myModuleManager = manager;
        this.myFileManager = fileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MyState getState() {
        Map<VirtualFile, Pair<Module, String>> map = this.myFileModuleMap;
        synchronized (map) {
            MyState result = new MyState();
            for (Map.Entry<VirtualFile, Pair<Module, String>> entry : this.myFileModuleMap.entrySet()) {
                VirtualFile file = entry.getKey();
                Pair<Module, String> pair = entry.getValue();
                Module module = pair == null ? null : (Module)pair.first;
                Entry e = new Entry();
                e.url = file.getUrl();
                e.moduleName = module == null ? "" : module.getName();
                e.title = pair == null ? "" : (String)pair.second;
                result.list.add(e);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(MyState state) {
        Map<VirtualFile, Pair<Module, String>> map = this.myFileModuleMap;
        synchronized (map) {
            this.myFileModuleMap.clear();
            for (Entry entry : state.list) {
                VirtualFile file = this.myFileManager.findFileByUrl(entry.url);
                Module module = this.myModuleManager.findModuleByName(entry.moduleName);
                if (file == null) continue;
                this.myFileModuleMap.put(file, (Pair<Module, String>)Pair.create((Object)module, (Object)entry.title));
            }
        }
    }

    public boolean isProjectConsole(@NotNull VirtualFile file) {
        return this.myFileModuleMap.containsKey(file);
    }

    @Nullable
    public Module getSelectedModule(@NotNull VirtualFile file) {
        Pair<Module, String> pair = this.myFileModuleMap.get(file);
        return pair == null ? null : (Module)pair.first;
    }

    @Nullable
    public String getSelectedModuleTitle(@NotNull VirtualFile file) {
        Pair<Module, String> pair = this.myFileModuleMap.get(file);
        return pair == null ? null : (String)pair.second;
    }

    public void setFileModule(@NotNull VirtualFile file, @NotNull Module module) {
        this.myFileModuleMap.put(file, (Pair<Module, String>)Pair.create((Object)module, (Object)GroovyConsoleUtil.getTitle(module)));
    }

    @NotNull
    public static GroovyConsoleStateService getInstance(@NotNull Project project) {
        return (GroovyConsoleStateService)ServiceManager.getService((Project)project, GroovyConsoleStateService.class);
    }

    public static class MyState {
        public Collection<Entry> list = ContainerUtil.newArrayList();
    }

    public static class Entry {
        public String url;
        public String moduleName;
        public String title;
    }
}

