/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.arithmetic.GrRangeExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class EquivalenceChecker {
    private static final int LITERAL_EXPRESSION = 1;
    private static final int REFERENCE_EXPRESSION = 3;
    private static final int CALL_EXPRESSION = 5;
    private static final int NEW_EXPRESSION = 6;
    private static final int ARRAY_LITERAL_EXPRESSION = 7;
    private static final int CLOSABLE_BLOCK_EXPRESSION = 8;
    private static final int PREFIX_EXPRESSION = 10;
    private static final int POSTFIX_EXPRESSION = 11;
    private static final int BINARY_EXPRESSION = 12;
    private static final int CONDITIONAL_EXPRESSION = 13;
    private static final int ASSIGNMENT_EXPRESSION = 14;
    private static final int ELVIS_EXPRESSION = 15;
    private static final int TYPE_CAST_EXPRESSION = 16;
    private static final int SAFE_CAST_EXPRESSION = 17;
    private static final int INSTANCEOF_EXPRESSION = 18;
    private static final int RANGE_EXPRESSION = 19;
    private static final int LIST_OR_MAP_EXPRESSION = 20;
    private static final int INDEX_EXPRESSION = 21;
    private static final int PROPERTY_SELECTION_EXPRESSION = 22;
    private static final int BLOCK_STATEMENT = 1;
    private static final int BREAK_STATEMENT = 2;
    private static final int CONTINUE_STATEMENT = 3;
    private static final int VAR_STATEMENT = 4;
    private static final int EMPTY_STATEMENT = 6;
    private static final int EXPRESSION_STATEMENT = 8;
    private static final int FOR_STATEMENT = 9;
    private static final int IF_STATEMENT = 10;
    private static final int RETURN_STATEMENT = 12;
    private static final int SWITCH_STATEMENT = 14;
    private static final int THROW_STATEMENT = 16;
    private static final int TRY_STATEMENT = 17;
    private static final int WHILE_STATEMENT = 18;
    private static final int SYNCHRONIZED_STATEMENT = 19;
    private static final int ASSERT_STATEMENT = 20;
    private static final int APPLICATION_STATEMENT = 21;

    private EquivalenceChecker() {
    }

    public static boolean statementsAreEquivalent(@Nullable GrStatement exp1, @Nullable GrStatement exp2) {
        int type2;
        if (exp1 == null && exp2 == null) {
            return true;
        }
        if (exp1 == null || exp2 == null) {
            return false;
        }
        int type1 = EquivalenceChecker.getStatementType(exp1);
        if (type1 != (type2 = EquivalenceChecker.getStatementType(exp2))) {
            return false;
        }
        switch (type1) {
            case 1: {
                return EquivalenceChecker.blockStatementsAreEquivalent((GrBlockStatement)exp1, (GrBlockStatement)exp2);
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return EquivalenceChecker.varStatementsAreEquivalent((GrVariableDeclaration)exp1, (GrVariableDeclaration)exp2);
            }
            case 6: {
                return true;
            }
            case 21: {
                return EquivalenceChecker.applicationStatementsAreEquivalent((GrApplicationStatement)exp1, (GrApplicationStatement)exp2);
            }
            case 8: {
                return EquivalenceChecker.expressionStatementsAreEquivalent((GrExpression)exp1, (GrExpression)exp2);
            }
            case 9: {
                return EquivalenceChecker.forInStatementsAreEquivalent((GrForStatement)exp1, (GrForStatement)exp2);
            }
            case 10: {
                return EquivalenceChecker.ifStatementsAreEquivalent((GrIfStatement)exp1, (GrIfStatement)exp2);
            }
            case 12: {
                return EquivalenceChecker.returnStatementsAreEquivalent((GrReturnStatement)exp1, (GrReturnStatement)exp2);
            }
            case 14: {
                return EquivalenceChecker.switchStatementsAreEquivalent((GrSwitchStatement)exp1, (GrSwitchStatement)exp2);
            }
            case 16: {
                return EquivalenceChecker.throwStatementsAreEquivalent((GrThrowStatement)exp1, (GrThrowStatement)exp2);
            }
            case 17: {
                return EquivalenceChecker.tryStatementsAreEquivalent((GrTryCatchStatement)exp1, (GrTryCatchStatement)exp2);
            }
            case 18: {
                return EquivalenceChecker.whileStatementsAreEquivalent((GrWhileStatement)exp1, (GrWhileStatement)exp2);
            }
            case 19: {
                return EquivalenceChecker.synchronizedStatementsAreEquivalent((GrSynchronizedStatement)exp1, (GrSynchronizedStatement)exp2);
            }
            case 20: {
                return EquivalenceChecker.assertStatementsAreEquivalent((GrAssertStatement)exp1, (GrAssertStatement)exp2);
            }
        }
        return false;
    }

    private static boolean applicationStatementsAreEquivalent(GrApplicationStatement statement1, GrApplicationStatement statement2) {
        GrNamedArgument[] namedArgs2;
        GrExpression[] args2;
        GrExpression funExpression2;
        GrExpression funExpression1 = statement1.getInvokedExpression();
        if (!EquivalenceChecker.expressionsAreEquivalent(funExpression1, funExpression2 = statement2.getInvokedExpression())) {
            return false;
        }
        GrCommandArgumentList argumentList1 = statement1.getArgumentList();
        if (argumentList1 == null) {
            return false;
        }
        GrCommandArgumentList argumentList2 = statement2.getArgumentList();
        if (argumentList2 == null) {
            return false;
        }
        GrExpression[] args1 = argumentList1.getExpressionArguments();
        if (!EquivalenceChecker.expressionListsAreEquivalent(args1, args2 = argumentList2.getExpressionArguments())) {
            return false;
        }
        GrNamedArgument[] namedArgs1 = argumentList1.getNamedArguments();
        return EquivalenceChecker.namedArgumentListsAreEquivalent(namedArgs1, namedArgs2 = argumentList2.getNamedArguments());
    }

    private static boolean assertStatementsAreEquivalent(GrAssertStatement statement1, GrAssertStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getAssertion(), statement2.getAssertion()) && EquivalenceChecker.expressionsAreEquivalent(statement1.getErrorMessage(), statement2.getErrorMessage());
    }

    private static boolean synchronizedStatementsAreEquivalent(GrSynchronizedStatement statement1, GrSynchronizedStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getMonitor(), statement2.getMonitor()) && EquivalenceChecker.openBlocksAreEquivalent(statement1.getBody(), statement2.getBody());
    }

    private static boolean varStatementsAreEquivalent(@NotNull GrVariableDeclaration statement1, @NotNull GrVariableDeclaration statement2) {
        GrVariable[] variables2;
        GrVariable[] variables1 = statement1.getVariables();
        if (variables1.length != (variables2 = statement2.getVariables()).length) {
            return false;
        }
        for (int i = 0; i < variables2.length; ++i) {
            if (EquivalenceChecker.variablesAreEquivalent(variables1[i], variables2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean variablesAreEquivalent(@NotNull GrVariable var1, @NotNull GrVariable var2) {
        PsiType type2;
        GrExpression initializer2;
        GrExpression initializer1 = var1.getInitializerGroovy();
        if (!EquivalenceChecker.expressionsAreEquivalent(initializer1, initializer2 = var2.getInitializerGroovy())) {
            return false;
        }
        PsiType type1 = var1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = var2.getType())) {
            return false;
        }
        String name1 = var1.getName();
        String name2 = var2.getName();
        return name1.equals(name2);
    }

    private static boolean tryStatementsAreEquivalent(@NotNull GrTryCatchStatement statement1, @NotNull GrTryCatchStatement statement2) {
        GrCatchClause[] catchBlocks2;
        GrOpenBlock tryBlock2;
        GrOpenBlock tryBlock1 = statement1.getTryBlock();
        if (!EquivalenceChecker.openBlocksAreEquivalent(tryBlock1, tryBlock2 = statement2.getTryBlock())) {
            return false;
        }
        GrFinallyClause finallyBlock1 = statement1.getFinallyClause();
        GrFinallyClause finallyBlock2 = statement2.getFinallyClause();
        if (finallyBlock1 != null ? finallyBlock2 == null || !EquivalenceChecker.openBlocksAreEquivalent(finallyBlock1.getBody(), finallyBlock2.getBody()) : finallyBlock2 != null) {
            return false;
        }
        GrCatchClause[] catchBlocks1 = statement1.getCatchClauses();
        if (catchBlocks1.length != (catchBlocks2 = statement2.getCatchClauses()).length) {
            return false;
        }
        for (int i = 0; i < catchBlocks2.length; ++i) {
            if (EquivalenceChecker.catchClausesAreEquivalent(catchBlocks1[i], catchBlocks2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean catchClausesAreEquivalent(GrCatchClause clause1, GrCatchClause clause2) {
        return EquivalenceChecker.parametersAreEquivalent(clause1.getParameter(), clause2.getParameter()) && EquivalenceChecker.openBlocksAreEquivalent(clause1.getBody(), clause2.getBody());
    }

    private static boolean parametersAreEquivalent(@Nullable GrParameter parameter1, @Nullable GrParameter parameter2) {
        PsiType type2;
        if (parameter1 == null || parameter2 == null) {
            return false;
        }
        PsiType type1 = parameter1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = parameter2.getType())) {
            return false;
        }
        String name1 = parameter1.getName();
        String name2 = parameter2.getName();
        return name1.equals(name2);
    }

    private static boolean typesAreEquivalent(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        return type1.equals(type2);
    }

    private static boolean whileStatementsAreEquivalent(@NotNull GrWhileStatement statement1, @NotNull GrWhileStatement statement2) {
        GrExpression condition1 = statement1.getCondition();
        GrExpression condition2 = statement2.getCondition();
        GrStatement body1 = statement1.getBody();
        GrStatement body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean forInStatementsAreEquivalent(@NotNull GrForStatement statement1, @NotNull GrForStatement statement2) {
        GrForClause clause2;
        GrForClause clause1 = statement1.getClause();
        if (!EquivalenceChecker.forClausesAreEquivalent(clause1, clause2 = statement2.getClause())) {
            return false;
        }
        GrStatement body1 = statement1.getBody();
        GrStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean forClausesAreEquivalent(@Nullable GrForClause statement1, @Nullable GrForClause statement2) {
        if (statement1 == null && statement2 == null) {
            return true;
        }
        if (statement1 == null || statement2 == null) {
            return false;
        }
        GrVariable var1 = statement1.getDeclaredVariable();
        GrVariable var2 = statement2.getDeclaredVariable();
        if (var1 == null && var2 == null) {
            return true;
        }
        if (var1 == null || var2 == null) {
            return false;
        }
        return EquivalenceChecker.variablesAreEquivalent(var1, var2);
    }

    private static boolean switchStatementsAreEquivalent(@NotNull GrSwitchStatement statement1, @NotNull GrSwitchStatement statement2) {
        GrCaseSection[] clauses2;
        GrExpression switchExpression2;
        GrExpression switchExpression1 = statement1.getCondition();
        if (!EquivalenceChecker.expressionsAreEquivalent(switchExpression1, switchExpression2 = statement2.getCondition())) {
            return false;
        }
        GrCaseSection[] clauses1 = statement1.getCaseSections();
        if (clauses1.length != (clauses2 = statement2.getCaseSections()).length) {
            return false;
        }
        for (int i = 0; i < clauses1.length; ++i) {
            GrCaseSection clause1 = clauses1[i];
            GrCaseSection clause2 = clauses2[i];
            if (EquivalenceChecker.caseClausesAreEquivalent(clause1, clause2)) continue;
            return false;
        }
        return true;
    }

    private static boolean caseClausesAreEquivalent(GrCaseSection clause1, GrCaseSection clause2) {
        GrStatement[] statements2;
        GrCaseLabel[] label2;
        GrCaseLabel[] label1 = clause1.getCaseLabels();
        if (label1.length != (label2 = clause2.getCaseLabels()).length) {
            return false;
        }
        for (int i = 0; i < label1.length; ++i) {
            GrCaseLabel l1 = label1[i];
            GrCaseLabel l2 = label2[i];
            if (EquivalenceChecker.expressionsAreEquivalent(l1.getValue(), l2.getValue())) continue;
            return false;
        }
        GrStatement[] statements1 = clause1.getStatements();
        if (statements1.length != (statements2 = clause2.getStatements()).length) {
            return false;
        }
        for (int i = 0; i < statements1.length; ++i) {
            if (EquivalenceChecker.statementsAreEquivalent(statements1[i], statements2[i])) continue;
            return false;
        }
        return false;
    }

    private static boolean blockStatementsAreEquivalent(@NotNull GrBlockStatement statement1, @NotNull GrBlockStatement statement2) {
        GrOpenBlock block1 = statement1.getBlock();
        GrOpenBlock block2 = statement2.getBlock();
        return EquivalenceChecker.openBlocksAreEquivalent(block1, block2);
    }

    private static boolean openBlocksAreEquivalent(@Nullable GrOpenBlock block1, @Nullable GrOpenBlock block2) {
        GrStatement[] statements2;
        if (block1 == null || block2 == null) {
            return false;
        }
        GrStatement[] statements1 = block1.getStatements();
        if (statements1.length != (statements2 = block2.getStatements()).length) {
            return false;
        }
        for (int i = 0; i < statements1.length; ++i) {
            if (EquivalenceChecker.statementsAreEquivalent(statements1[i], statements2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean ifStatementsAreEquivalent(@NotNull GrIfStatement statement1, @NotNull GrIfStatement statement2) {
        GrExpression condition1 = statement1.getCondition();
        GrExpression condition2 = statement2.getCondition();
        GrStatement thenBranch1 = statement1.getThenBranch();
        GrStatement thenBranch2 = statement2.getThenBranch();
        GrStatement elseBranch1 = statement1.getElseBranch();
        GrStatement elseBranch2 = statement2.getElseBranch();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(thenBranch1, thenBranch2) && EquivalenceChecker.statementsAreEquivalent(elseBranch1, elseBranch2);
    }

    private static boolean expressionStatementsAreEquivalent(@NotNull GrExpression statement1, @NotNull GrExpression statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1, statement2);
    }

    private static boolean returnStatementsAreEquivalent(@NotNull GrReturnStatement statement1, @NotNull GrReturnStatement statement2) {
        GrExpression returnValue1 = statement1.getReturnValue();
        GrExpression returnValue2 = statement2.getReturnValue();
        return EquivalenceChecker.expressionsAreEquivalent(returnValue1, returnValue2);
    }

    private static boolean throwStatementsAreEquivalent(@NotNull GrThrowStatement statement1, @NotNull GrThrowStatement statement2) {
        GrExpression exception1 = statement1.getException();
        GrExpression exception2 = statement2.getException();
        return EquivalenceChecker.expressionsAreEquivalent(exception1, exception2);
    }

    public static boolean expressionsAreEquivalent(@Nullable GrExpression exp1, @Nullable GrExpression exp2) {
        int type2;
        if (exp1 == null && exp2 == null) {
            return true;
        }
        if (exp1 == null || exp2 == null) {
            return false;
        }
        GrExpression expToCompare1 = (GrExpression)PsiUtil.skipParentheses(exp1, false);
        GrExpression expToCompare2 = (GrExpression)PsiUtil.skipParentheses(exp2, false);
        int type1 = EquivalenceChecker.getExpressionType(expToCompare1);
        if (type1 != (type2 = EquivalenceChecker.getExpressionType(expToCompare2))) {
            return false;
        }
        switch (type1) {
            case 1: 
            case 3: {
                String text1 = expToCompare1.getText();
                String text2 = expToCompare2.getText();
                return text1.equals(text2);
            }
            case 5: {
                return EquivalenceChecker.methodCallExpressionsAreEquivalent((GrMethodCall)expToCompare1, (GrMethodCall)expToCompare2);
            }
            case 6: {
                return EquivalenceChecker.newExpressionsAreEquivalent((GrNewExpression)expToCompare1, (GrNewExpression)expToCompare2);
            }
            case 7: {
                return EquivalenceChecker.arrayDeclarationsAreEquivalent((GrArrayDeclaration)((Object)expToCompare1), (GrArrayDeclaration)((Object)expToCompare2));
            }
            case 10: {
                return EquivalenceChecker.prefixExpressionsAreEquivalent((GrUnaryExpression)expToCompare1, (GrUnaryExpression)expToCompare2);
            }
            case 11: {
                return EquivalenceChecker.postfixExpressionsAreEquivalent((GrUnaryExpression)expToCompare1, (GrUnaryExpression)expToCompare2);
            }
            case 12: {
                return EquivalenceChecker.binaryExpressionsAreEquivalent((GrBinaryExpression)expToCompare1, (GrBinaryExpression)expToCompare2);
            }
            case 14: {
                return EquivalenceChecker.assignmentExpressionsAreEquivalent((GrAssignmentExpression)expToCompare1, (GrAssignmentExpression)expToCompare2);
            }
            case 13: {
                return EquivalenceChecker.conditionalExpressionsAreEquivalent((GrConditionalExpression)expToCompare1, (GrConditionalExpression)expToCompare2);
            }
            case 15: {
                return EquivalenceChecker.elvisExpressionsAreEquivalent((GrElvisExpression)expToCompare1, (GrElvisExpression)expToCompare2);
            }
            case 19: {
                return EquivalenceChecker.rangeExpressionsAreEquivalent((GrRangeExpression)expToCompare1, (GrRangeExpression)expToCompare2);
            }
            case 16: {
                return EquivalenceChecker.typecastExpressionsAreEquivalent((GrTypeCastExpression)expToCompare1, (GrTypeCastExpression)expToCompare2);
            }
            case 17: {
                return EquivalenceChecker.safeCastExpressionsAreEquivalent((GrSafeCastExpression)expToCompare1, (GrSafeCastExpression)expToCompare2);
            }
            case 18: {
                return EquivalenceChecker.instanceofExpressionsAreEquivalent((GrInstanceOfExpression)expToCompare1, (GrInstanceOfExpression)expToCompare2);
            }
            case 21: {
                return EquivalenceChecker.indexExpressionsAreEquivalent((GrIndexProperty)expToCompare1, (GrIndexProperty)expToCompare2);
            }
            case 20: {
                return EquivalenceChecker.listOrMapExpressionsAreEquivalent((GrListOrMap)expToCompare1, (GrListOrMap)expToCompare2);
            }
            case 8: {
                return EquivalenceChecker.closableBlockExpressionsAreEquivalent((GrClosableBlock)expToCompare1, (GrClosableBlock)expToCompare2);
            }
            case 22: {
                return EquivalenceChecker.textOfExpressionsIsEquivalent(expToCompare1, expToCompare2);
            }
        }
        return false;
    }

    private static boolean textOfExpressionsIsEquivalent(GrExpression expToCompare1, GrExpression expToCompare2) {
        String text1 = expToCompare1.getText();
        String text2 = expToCompare2.getText();
        return text1.equals(text2);
    }

    private static boolean closableBlockExpressionsAreEquivalent(GrClosableBlock closableBlock1, GrClosableBlock closableBlock2) {
        GrStatement[] statements2;
        GrStatement[] statements1 = closableBlock1.getStatements();
        if (statements1.length != (statements2 = closableBlock2.getStatements()).length) {
            return false;
        }
        for (int i = 0; i < statements1.length; ++i) {
            if (EquivalenceChecker.statementsAreEquivalent(statements1[i], statements2[i])) continue;
            return false;
        }
        GrParameter[] parameters1 = closableBlock1.getParameters();
        GrParameter[] parameters2 = closableBlock2.getParameters();
        return EquivalenceChecker.parametersAreEquivalent(parameters1, parameters2);
    }

    private static boolean parametersAreEquivalent(GrParameter[] parameters1, GrParameter[] parameters2) {
        if (parameters1.length != parameters2.length) {
            return false;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            if (EquivalenceChecker.parametersAreEquivalent(parameters1[i], parameters2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean listOrMapExpressionsAreEquivalent(GrListOrMap expression1, GrListOrMap expression2) {
        return EquivalenceChecker.expressionListsAreEquivalent(expression1.getInitializers(), expression2.getInitializers()) && EquivalenceChecker.namedArgumentListsAreEquivalent(expression1.getNamedArguments(), expression2.getNamedArguments());
    }

    private static boolean arrayDeclarationsAreEquivalent(GrArrayDeclaration expression1, GrArrayDeclaration expression2) {
        int count2;
        int count1 = expression1.getArrayCount();
        if (count1 != (count2 = expression2.getArrayCount())) {
            return false;
        }
        GrExpression[] bounds1 = expression1.getBoundExpressions();
        GrExpression[] bounds2 = expression2.getBoundExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(bounds1, bounds2);
    }

    private static boolean instanceofExpressionsAreEquivalent(GrInstanceOfExpression expression1, GrInstanceOfExpression expression2) {
        GrExpression operand2;
        GrExpression operand1 = expression1.getOperand();
        if (!EquivalenceChecker.expressionsAreEquivalent(operand1, operand2 = expression2.getOperand())) {
            return false;
        }
        GrTypeElement typeElement1 = expression1.getTypeElement();
        GrTypeElement typeElement2 = expression2.getTypeElement();
        if (typeElement1 == null || typeElement2 == null) {
            return false;
        }
        PsiType type1 = typeElement1.getType();
        PsiType type2 = typeElement2.getType();
        return EquivalenceChecker.typesAreEquivalent(type1, type2);
    }

    private static boolean indexExpressionsAreEquivalent(GrIndexProperty expression1, GrIndexProperty expression2) {
        return EquivalenceChecker.expressionsAreEquivalent(expression1.getInvokedExpression(), expression2.getInvokedExpression()) && EquivalenceChecker.argumentListsAreEquivalent(expression1.getArgumentList(), expression2.getArgumentList());
    }

    private static boolean typecastExpressionsAreEquivalent(GrTypeCastExpression expression1, GrTypeCastExpression expression2) {
        GrExpression operand2;
        GrExpression operand1 = expression1.getOperand();
        if (!EquivalenceChecker.expressionsAreEquivalent(operand1, operand2 = expression2.getOperand())) {
            return false;
        }
        PsiType type1 = expression1.getCastTypeElement().getType();
        PsiType type2 = expression2.getCastTypeElement().getType();
        return EquivalenceChecker.typesAreEquivalent(type1, type2);
    }

    private static boolean safeCastExpressionsAreEquivalent(GrSafeCastExpression expression1, GrSafeCastExpression expression2) {
        GrExpression operand2;
        GrExpression operand1 = expression1.getOperand();
        if (!EquivalenceChecker.expressionsAreEquivalent(operand1, operand2 = expression2.getOperand())) {
            return false;
        }
        GrTypeElement typeElement1 = expression1.getCastTypeElement();
        GrTypeElement typeElement2 = expression2.getCastTypeElement();
        PsiType safe1 = typeElement1 == null ? null : typeElement1.getType();
        PsiType safe2 = typeElement2 == null ? null : typeElement2.getType();
        return EquivalenceChecker.typesAreEquivalent(safe1, safe2);
    }

    private static boolean methodCallExpressionsAreEquivalent(@NotNull GrMethodCall methodExp1, @NotNull GrMethodCall methodExp2) {
        GrExpression[] closures2;
        GrExpression methodExpression2;
        GrExpression methodExpression1 = methodExp1.getInvokedExpression();
        if (!EquivalenceChecker.expressionsAreEquivalent(methodExpression1, methodExpression2 = methodExp2.getInvokedExpression())) {
            return false;
        }
        GrExpression[] closures1 = methodExp1.getClosureArguments();
        if (!EquivalenceChecker.expressionListsAreEquivalent(closures1, closures2 = methodExp2.getClosureArguments())) {
            return false;
        }
        return EquivalenceChecker.argumentListsAreEquivalent(methodExp1.getArgumentList(), methodExp2.getArgumentList());
    }

    private static boolean argumentListsAreEquivalent(@Nullable GrArgumentList list1, @Nullable GrArgumentList list2) {
        GrNamedArgument[] namedArgs2;
        GrExpression[] args2;
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        GrExpression[] args1 = list1.getExpressionArguments();
        if (!EquivalenceChecker.expressionListsAreEquivalent(args1, args2 = list2.getExpressionArguments())) {
            return false;
        }
        GrNamedArgument[] namedArgs1 = list1.getNamedArguments();
        return EquivalenceChecker.namedArgumentListsAreEquivalent(namedArgs1, namedArgs2 = list2.getNamedArguments());
    }

    private static boolean namedArgumentListsAreEquivalent(GrNamedArgument[] namedArgs1, GrNamedArgument[] namedArgs2) {
        if (namedArgs1.length != namedArgs2.length) {
            return false;
        }
        for (GrNamedArgument arg1 : namedArgs1) {
            GrArgumentLabel label1 = arg1.getLabel();
            if (label1 == null) {
                return false;
            }
            String name1 = label1.getName();
            boolean found = false;
            GrExpression expression1 = arg1.getExpression();
            for (GrNamedArgument arg2 : namedArgs2) {
                GrArgumentLabel label2 = arg2.getLabel();
                if (label2 == null) {
                    return false;
                }
                String name2 = label2.getName();
                GrExpression expression2 = arg2.getExpression();
                if (name1 == null) {
                    if (name2 != null || !EquivalenceChecker.expressionsAreEquivalent((GrExpression)label1.getNameElement(), (GrExpression)label2.getNameElement()) || !EquivalenceChecker.expressionsAreEquivalent(expression1, expression2)) continue;
                    found = true;
                    break;
                }
                if (!name1.equals(name2) || !EquivalenceChecker.expressionsAreEquivalent(expression1, expression2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean newExpressionsAreEquivalent(@NotNull GrNewExpression newExp1, @NotNull GrNewExpression newExp2) {
        PsiMethod constructor1 = newExp1.resolveMethod();
        PsiMethod constructor2 = newExp2.resolveMethod();
        if (constructor1 == null || constructor2 == null || constructor1.equals(constructor2)) {
            return false;
        }
        return EquivalenceChecker.argumentListsAreEquivalent(newExp1.getArgumentList(), newExp2.getArgumentList());
    }

    private static boolean prefixExpressionsAreEquivalent(@NotNull GrUnaryExpression prefixExp1, @NotNull GrUnaryExpression prefixExp2) {
        IElementType sign2;
        IElementType sign1 = prefixExp1.getOperationTokenType();
        if (sign1 != (sign2 = prefixExp2.getOperationTokenType())) {
            return false;
        }
        GrExpression operand1 = prefixExp1.getOperand();
        GrExpression operand2 = prefixExp2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean postfixExpressionsAreEquivalent(@NotNull GrUnaryExpression postfixExp1, @NotNull GrUnaryExpression postfixExp2) {
        IElementType sign2;
        IElementType sign1 = postfixExp1.getOperationTokenType();
        if (sign1 != (sign2 = postfixExp2.getOperationTokenType())) {
            return false;
        }
        GrExpression operand1 = postfixExp1.getOperand();
        GrExpression operand2 = postfixExp2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean binaryExpressionsAreEquivalent(@NotNull GrBinaryExpression binaryExp1, @NotNull GrBinaryExpression binaryExp2) {
        IElementType sign2;
        IElementType sign1 = binaryExp1.getOperationTokenType();
        if (sign1 != (sign2 = binaryExp2.getOperationTokenType())) {
            return false;
        }
        GrExpression lhs1 = binaryExp1.getLeftOperand();
        GrExpression lhs2 = binaryExp2.getLeftOperand();
        GrExpression rhs1 = binaryExp1.getRightOperand();
        GrExpression rhs2 = binaryExp2.getRightOperand();
        return EquivalenceChecker.expressionsAreEquivalent(lhs1, lhs2) && EquivalenceChecker.expressionsAreEquivalent(rhs1, rhs2);
    }

    private static boolean rangeExpressionsAreEquivalent(@NotNull GrRangeExpression rangeExp1, @NotNull GrRangeExpression rangeExp2) {
        return EquivalenceChecker.expressionsAreEquivalent(rangeExp1.getLeftOperand(), rangeExp2.getLeftOperand()) && EquivalenceChecker.expressionsAreEquivalent(rangeExp1.getRightOperand(), rangeExp2.getRightOperand()) && EquivalenceChecker.isInclusive(rangeExp1) == EquivalenceChecker.isInclusive(rangeExp2);
    }

    private static boolean isInclusive(GrRangeExpression range) {
        for (PsiElement child : range.getChildren()) {
            if (!"..".equals(child.getText())) continue;
            return true;
        }
        return false;
    }

    private static boolean assignmentExpressionsAreEquivalent(@NotNull GrAssignmentExpression assignExp1, @NotNull GrAssignmentExpression assignExp2) {
        IElementType sign2;
        IElementType sign1 = assignExp1.getOperationTokenType();
        if (sign1 != (sign2 = assignExp2.getOperationTokenType())) {
            return false;
        }
        GrExpression lhs1 = assignExp1.getLValue();
        GrExpression lhs2 = assignExp2.getLValue();
        GrExpression rhs1 = assignExp1.getRValue();
        GrExpression rhs2 = assignExp2.getRValue();
        return EquivalenceChecker.expressionsAreEquivalent(lhs1, lhs2) && EquivalenceChecker.expressionsAreEquivalent(rhs1, rhs2);
    }

    private static boolean conditionalExpressionsAreEquivalent(@NotNull GrConditionalExpression condExp1, @NotNull GrConditionalExpression condExp2) {
        GrExpression condition1 = condExp1.getCondition();
        GrExpression condition2 = condExp2.getCondition();
        GrExpression thenExpression1 = condExp1.getThenBranch();
        GrExpression thenExpression2 = condExp2.getThenBranch();
        GrExpression elseExpression1 = condExp1.getElseBranch();
        GrExpression elseExpression2 = condExp2.getElseBranch();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(thenExpression1, thenExpression2) && EquivalenceChecker.expressionsAreEquivalent(elseExpression1, elseExpression2);
    }

    private static boolean elvisExpressionsAreEquivalent(@NotNull GrElvisExpression condExp1, @NotNull GrElvisExpression condExp2) {
        GrExpression condition1 = condExp1.getCondition();
        GrExpression condition2 = condExp2.getCondition();
        GrExpression elseExpression1 = condExp1.getElseBranch();
        GrExpression elseExpression2 = condExp2.getElseBranch();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(elseExpression1, elseExpression2);
    }

    private static boolean expressionListsAreEquivalent(@Nullable GrExpression[] expressions1, @Nullable GrExpression[] expressions2) {
        if (expressions1 == null && expressions2 == null) {
            return true;
        }
        if (expressions1 == null || expressions2 == null) {
            return false;
        }
        if (expressions1.length != expressions2.length) {
            return false;
        }
        for (int i = 0; i < expressions1.length; ++i) {
            if (EquivalenceChecker.expressionsAreEquivalent(expressions1[i], expressions2[i])) continue;
            return false;
        }
        return true;
    }

    private static int getExpressionType(@Nullable GrExpression exp) {
        if (exp instanceof GrArrayDeclaration) {
            return 7;
        }
        if (exp instanceof GrLiteral) {
            return 1;
        }
        if (exp instanceof GrReferenceExpression) {
            return 3;
        }
        if (exp instanceof GrTypeCastExpression) {
            return 16;
        }
        if (exp instanceof GrSafeCastExpression) {
            return 17;
        }
        if (exp instanceof GrInstanceOfExpression) {
            return 18;
        }
        if (exp instanceof GrNewExpression) {
            return 6;
        }
        if (exp instanceof GrMethodCall) {
            return 5;
        }
        if (exp instanceof GrUnaryExpression) {
            return ((GrUnaryExpression)exp).isPostfix() ? 11 : 10;
        }
        if (exp instanceof GrAssignmentExpression) {
            return 14;
        }
        if (exp instanceof GrRangeExpression) {
            return 19;
        }
        if (exp instanceof GrBinaryExpression) {
            return 12;
        }
        if (exp instanceof GrElvisExpression) {
            return 15;
        }
        if (exp instanceof GrConditionalExpression) {
            return 13;
        }
        if (exp instanceof GrIndexProperty) {
            return 21;
        }
        if (exp instanceof GrListOrMap) {
            return 20;
        }
        if (exp instanceof GrClosableBlock) {
            return 8;
        }
        return -1;
    }

    private static int getStatementType(@Nullable GrStatement statement) {
        if (statement instanceof GrBlockStatement) {
            return 1;
        }
        if (statement instanceof GrBreakStatement) {
            return 2;
        }
        if (statement instanceof GrContinueStatement) {
            return 3;
        }
        if (statement instanceof GrVariableDeclaration) {
            return 4;
        }
        if (statement instanceof GrApplicationStatement) {
            return 21;
        }
        if (statement instanceof GrExpression) {
            return 8;
        }
        if (statement instanceof GrForStatement) {
            return 9;
        }
        if (statement instanceof GrIfStatement) {
            return 10;
        }
        if (statement instanceof GrReturnStatement) {
            return 12;
        }
        if (statement instanceof GrSwitchStatement) {
            return 14;
        }
        if (statement instanceof GrThrowStatement) {
            return 16;
        }
        if (statement instanceof GrTryCatchStatement) {
            return 17;
        }
        if (statement instanceof GrWhileStatement) {
            return 18;
        }
        if (statement instanceof GrSynchronizedStatement) {
            return 19;
        }
        if (statement instanceof GrAssertStatement) {
            return 20;
        }
        return -1;
    }
}

