/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GroovySynchronizationOnVariableInitializedWithLiteralInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Threading issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Synchronization on variable initialized with literal";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Synchronization on variable '#ref', which was initialized with a literal #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSynchronizedStatement(GrSynchronizedStatement synchronizedStatement) {
            super.visitSynchronizedStatement(synchronizedStatement);
            GrExpression lock = synchronizedStatement.getMonitor();
            if (lock == null || !(lock instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)lock).resolve();
            if (referent instanceof GrVariable) {
                GrVariable variable = (GrVariable)referent;
                GrExpression initializer = variable.getInitializerGroovy();
                if (initializer == null) {
                    return;
                }
                if (!(initializer instanceof GrLiteral)) {
                    return;
                }
                this.registerError(lock);
            } else if (referent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)referent;
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    return;
                }
                if (!(initializer instanceof PsiLiteralExpression)) {
                    return;
                }
                this.registerError(lock);
            }
        }
    }
}

