/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GroovyEmptySyncBlockInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Threading issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Empty 'synchronized' block";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Empty '#ref' block #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSynchronizedStatement(GrSynchronizedStatement synchronizedStatement) {
            super.visitSynchronizedStatement(synchronizedStatement);
            GrOpenBlock body = synchronizedStatement.getBody();
            if (body == null || !Visitor.isEmpty(body)) {
                return;
            }
            this.registerError(synchronizedStatement.getFirstChild());
        }

        private static boolean isEmpty(GrOpenBlock body) {
            GrStatement[] statements = body.getStatements();
            return statements.length == 0;
        }
    }
}

