/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.ConventionOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;

public abstract class ConventionInspection
extends BaseInspection {
    public String m_regex = this.getDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Naming Conventions";
    }

    @NonNls
    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    protected String getRegex() {
        return this.m_regex;
    }

    protected int getMinLength() {
        return this.m_minLength;
    }

    protected int getMaxLength() {
        return this.m_maxLength;
    }

    protected boolean isValid(String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (length > this.m_maxLength) {
            return false;
        }
        if ("SerialVersionUID".equals(name)) {
            return true;
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public JComponent createOptionsPanel() {
        return new ConventionOptionsPanel((InspectionProfileEntry)this, "m_minLength", "m_maxLength", "m_regex", "m_regexPattern", new JComponent[0]);
    }
}

