/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.CyclomaticComplexityVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyOverlyComplexMethodInspectionBase
extends GroovyMethodMetricInspection {
    @NotNull
    public String getDisplayName() {
        return "Overly complex method";
    }

    @NotNull
    public String getGroupDisplayName() {
        return "Method Metrics";
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return "Method complexity limit:";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' is overly complex ( cyclomatic complexity =" + args[0] + '>' + args[1] + ')';
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod grMethod) {
            super.visitMethod(grMethod);
            int limit = GroovyOverlyComplexMethodInspectionBase.this.getLimit();
            CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
            GrOpenBlock body = grMethod.getBlock();
            if (body == null) {
                return;
            }
            body.accept(visitor);
            int complexity = visitor.getComplexity();
            if (complexity <= limit) {
                return;
            }
            this.registerMethodError(grMethod, complexity, limit);
        }
    }
}

