/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control.finalVar;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class VariableInitializationChecker {
    private static final LightCacheKey<Map<GroovyPsiElement, Boolean>> KEY = LightCacheKey.createByFileModificationCount();

    public static boolean isVariableDefinitelyInitialized(@NotNull String varName, @NotNull Instruction[] controlFlow) {
        DFAEngine<Data> engine = new DFAEngine<Data>(controlFlow, new MyDfaInstance(varName), new MySemilattice());
        ArrayList<Data> result = engine.performDFAWithTimeout();
        if (result == null) {
            return false;
        }
        return (Boolean)result.get(controlFlow.length - 1).get();
    }

    public static boolean isVariableDefinitelyInitializedCached(@NotNull PsiVariable var, @NotNull GroovyPsiElement context, @NotNull Instruction[] controlFlow) {
        Boolean cached;
        HashMap map = KEY.getCachedValue((PsiElement)var);
        if (map == null) {
            map = ContainerUtil.newHashMap();
            KEY.putCachedValue((PsiElement)var, map);
        }
        if ((cached = (Boolean)map.get(context)) != null) {
            return cached;
        }
        boolean result = VariableInitializationChecker.isVariableDefinitelyInitialized(var.getName(), controlFlow);
        map.put(context, result);
        return result;
    }

    private static class Data
    extends Ref<Boolean> {
        public Data(Boolean value) {
            super((Object)value);
        }
    }

    private static class MySemilattice
    implements Semilattice<Data> {
        private MySemilattice() {
        }

        @Override
        @NotNull
        public Data join(@NotNull ArrayList<Data> ins) {
            if (ins.isEmpty()) {
                return new Data(false);
            }
            boolean b = true;
            for (Data data : ins) {
                b &= ((Boolean)data.get()).booleanValue();
            }
            return new Data(b);
        }

        @Override
        public boolean eq(Data e1, Data e2) {
            return ((Boolean)e1.get()).booleanValue() == ((Boolean)e2.get()).booleanValue();
        }
    }

    private static class MyDfaInstance
    implements DfaInstance<Data> {
        private final String myVar;

        public MyDfaInstance(String var) {
            this.myVar = var;
        }

        @Override
        public void fun(Data e, Instruction instruction) {
            if (instruction instanceof ReadWriteVariableInstruction && ((ReadWriteVariableInstruction)instruction).getVariableName().equals(this.myVar)) {
                e.set(true);
            }
        }

        @Override
        @NotNull
        public Data initial() {
            return new Data(false);
        }

        @Override
        public boolean isForward() {
            return true;
        }
    }
}

