/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyUnnecessaryReturnInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Unnecessary 'return' statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref is unnecessary as the last statement in a method with no return value #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        return new UnnecessaryReturnFix();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(GrReturnStatement returnStatement) {
            super.visitReturnStatement(returnStatement);
            GrExpression returnValue = returnStatement.getReturnValue();
            if (returnValue != null) {
                return;
            }
            GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrMethod.class);
            if (method == null) {
                return;
            }
            GrOpenBlock body = method.getBlock();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.openBlockCompletesWithStatement(body, returnStatement)) {
                this.registerStatementError(returnStatement, new Object[0]);
            }
        }
    }

    private static class UnnecessaryReturnFix
    extends GroovyFix {
        private UnnecessaryReturnFix() {
        }

        @NotNull
        public String getName() {
            return "Remove unnecessary return";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement returnKeywordElement = descriptor.getPsiElement();
            GrReturnStatement returnStatement = (GrReturnStatement)returnKeywordElement.getParent();
            assert (returnStatement != null);
            returnStatement.removeStatement();
        }
    }
}

