/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GroovyIfStatementWithIdenticalBranchesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getDisplayName() {
        return "If statement with identical branches";
    }

    @NotNull
    public String getGroupDisplayName() {
        return "Control Flow";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "'#ref' statement with identical branches #loc";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        return new CollapseIfFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementWithIdenticalBranchesVisitor();
    }

    private static class IfStatementWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithIdenticalBranchesVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            super.visitIfStatement(statement);
            GrStatement thenBranch = statement.getThenBranch();
            GrStatement elseBranch = statement.getElseBranch();
            if (thenBranch == null || elseBranch == null) {
                return;
            }
            if (EquivalenceChecker.statementsAreEquivalent(thenBranch, elseBranch)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }
    }

    private static class CollapseIfFix
    extends GroovyFix {
        private CollapseIfFix() {
        }

        @NotNull
        public String getName() {
            return "Collapse 'if' statement'";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement identifier = descriptor.getPsiElement();
            GrIfStatement statement = (GrIfStatement)identifier.getParent();
            assert (statement != null);
            GrStatement thenBranch = statement.getThenBranch();
            CollapseIfFix.replaceStatement((GrStatement)statement, thenBranch);
        }
    }
}

