/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyPointlessArithmeticInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        return "Pointless arithmetic expression";
    }

    @NotNull
    public String getGroupDisplayName() {
        return "Potentially confusing code constructs";
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessArithmeticVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        return GroovyInspectionBundle.message("pointless.arithmetic.error.message", GroovyPointlessArithmeticInspection.calculateReplacementExpression((GrExpression)args[0]));
    }

    private static String calculateReplacementExpression(GrExpression expression) {
        GrBinaryExpression exp = (GrBinaryExpression)expression;
        IElementType sign = exp.getOperationTokenType();
        GrExpression lhs = exp.getLeftOperand();
        GrExpression rhs = exp.getRightOperand();
        assert (rhs != null);
        if (GroovyTokenTypes.mPLUS == sign) {
            if (GroovyPointlessArithmeticInspection.isZero(lhs)) {
                return rhs.getText();
            }
            return lhs.getText();
        }
        if (GroovyTokenTypes.mMINUS == sign) {
            return lhs.getText();
        }
        if (GroovyTokenTypes.mSTAR == sign) {
            if (GroovyPointlessArithmeticInspection.isOne(lhs)) {
                return rhs.getText();
            }
            if (GroovyPointlessArithmeticInspection.isOne(rhs)) {
                return lhs.getText();
            }
            return "0";
        }
        if (GroovyTokenTypes.mDIV == sign) {
            return lhs.getText();
        }
        return "";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        return new PointlessArithmeticFix();
    }

    private static boolean subtractionExpressionIsPointless(GrExpression rhs) {
        return GroovyPointlessArithmeticInspection.isZero(rhs);
    }

    private static boolean additionExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessArithmeticInspection.isZero(lhs) || GroovyPointlessArithmeticInspection.isZero(rhs);
    }

    private static boolean multiplyExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessArithmeticInspection.isZero(lhs) || GroovyPointlessArithmeticInspection.isZero(rhs) || GroovyPointlessArithmeticInspection.isOne(lhs) || GroovyPointlessArithmeticInspection.isOne(rhs);
    }

    private static boolean divideExpressionIsPointless(GrExpression rhs) {
        return GroovyPointlessArithmeticInspection.isOne(rhs);
    }

    private static boolean isZero(GrExpression expression) {
        PsiElement inner = PsiUtil.skipParentheses(expression, false);
        if (inner == null) {
            return false;
        }
        String text = inner.getText();
        return "0".equals(text) || "0x0".equals(text) || "0X0".equals(text) || "0.0".equals(text) || "0L".equals(text) || "0l".equals(text) || "0b0".equals(text) || "0B0".equals(text);
    }

    private static boolean isOne(GrExpression expression) {
        PsiElement inner = PsiUtil.skipParentheses(expression, false);
        if (inner == null) {
            return false;
        }
        String text = inner.getText();
        return "1".equals(text) || "0x1".equals(text) || "0X1".equals(text) || "1.0".equals(text) || "1L".equals(text) || "1l".equals(text) || "0b0".equals(text) || "0B0".equals(text);
    }

    private static class PointlessArithmeticVisitor
    extends BaseInspectionVisitor {
        private final TokenSet arithmeticTokens = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mPLUS, GroovyTokenTypes.mMINUS, GroovyTokenTypes.mSTAR, GroovyTokenTypes.mDIV});

        private PointlessArithmeticVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            IElementType sign = expression.getOperationTokenType();
            if (!this.arithmeticTokens.contains(sign)) {
                return;
            }
            GrExpression lhs = expression.getLeftOperand();
            boolean isPointless = sign.equals(GroovyTokenTypes.mPLUS) ? GroovyPointlessArithmeticInspection.additionExpressionIsPointless(lhs, rhs) : (sign.equals(GroovyTokenTypes.mMINUS) ? GroovyPointlessArithmeticInspection.subtractionExpressionIsPointless(rhs) : (sign.equals(GroovyTokenTypes.mSTAR) ? GroovyPointlessArithmeticInspection.multiplyExpressionIsPointless(lhs, rhs) : (sign.equals(GroovyTokenTypes.mDIV) ? GroovyPointlessArithmeticInspection.divideExpressionIsPointless(rhs) : false)));
            if (!isPointless) {
                return;
            }
            this.registerError(expression);
        }
    }

    private static class PointlessArithmeticFix
    extends GroovyFix {
        private PointlessArithmeticFix() {
        }

        @NotNull
        public String getName() {
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            GrExpression expression = (GrExpression)descriptor.getPsiElement();
            String newExpression = GroovyPointlessArithmeticInspection.calculateReplacementExpression(expression);
            PointlessArithmeticFix.replaceExpression(expression, newExpression);
        }
    }
}

