/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyDoubleNegationInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Potentially confusing code constructs";
    }

    @NotNull
    public String getDisplayName() {
        return "Double negation";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return "Double negation #ref #loc";
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        return new DoubleNegationFix();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleNegationVisitor();
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        @Override
        public void visitUnaryExpression(GrUnaryExpression expression) {
            super.visitUnaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mLNOT.equals(tokenType)) {
                return;
            }
            this.checkParent(expression);
        }

        @Override
        public void visitBinaryExpression(GrBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mNOT_EQUAL.equals(tokenType)) {
                return;
            }
            this.checkParent(expression);
        }

        private void checkParent(GrExpression expression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof GrParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof GrUnaryExpression)) {
                return;
            }
            GrUnaryExpression prefixExpression = (GrUnaryExpression)parent;
            IElementType parentTokenType = prefixExpression.getOperationTokenType();
            if (!GroovyTokenTypes.mLNOT.equals(parentTokenType)) {
                return;
            }
            this.registerError(prefixExpression);
        }
    }

    private static class DoubleNegationFix
    extends GroovyFix {
        private DoubleNegationFix() {
        }

        @NotNull
        public String getName() {
            return "Remove double negation";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            GrUnaryExpression expression = (GrUnaryExpression)descriptor.getPsiElement();
            GrExpression operand = (GrExpression)PsiUtil.skipParentheses(expression.getOperand(), false);
            if (operand instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)operand;
                GrExpression innerOperand = prefixExpression.getOperand();
                if (innerOperand == null) {
                    return;
                }
                DoubleNegationFix.replaceExpression(expression, innerOperand.getText());
            } else if (operand instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)operand;
                GrExpression lhs = binaryExpression.getLeftOperand();
                String lhsText = lhs.getText();
                StringBuilder builder = new StringBuilder(lhsText);
                builder.append("==");
                GrExpression rhs = binaryExpression.getRightOperand();
                if (rhs != null) {
                    String rhsText = rhs.getText();
                    builder.append(rhsText);
                }
                DoubleNegationFix.replaceExpression(expression, builder.toString());
            }
        }
    }
}

