/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrEqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        return GroovyInspectionBundle.message("equals.between.inconvertible.types.tooltip", args[0], args[1], args[2]);
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitMethodCallExpression(GrMethodCallExpression methodCallExpression) {
            super.visitMethodCallExpression(methodCallExpression);
            this.processMethodCall(methodCallExpression);
        }

        @Override
        public void visitApplicationStatement(GrApplicationStatement applicationStatement) {
            super.visitApplicationStatement(applicationStatement);
            this.processMethodCall(applicationStatement);
        }

        @Override
        public void visitBinaryExpression(GrBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            if (expression.getOperationTokenType() != GroovyTokenTypes.mEQUAL) {
                return;
            }
            if (expression.getRightOperand() == null) {
                return;
            }
            PsiType rightType = expression.getRightOperand().getType();
            PsiType leftType = expression.getLeftOperand().getType();
            if (rightType == null || leftType == null) {
                return;
            }
            if (TypeUtils.areConvertible((PsiType)rightType, (PsiType)leftType)) {
                return;
            }
            this.registerError((PsiElement)expression, "==", leftType.getPresentableText(), rightType.getPresentableText());
        }

        private void processMethodCall(GrMethodCall methodCall) {
            PsiMethod method = methodCall.resolveMethod();
            if (method == null || !method.getName().equals("equals")) {
                return;
            }
            GrArgumentList argumentList = methodCall.getArgumentList();
            GrExpression[] arguments = argumentList.getExpressionArguments();
            if (arguments.length != 1) {
                return;
            }
            PsiType rightType = arguments[0].getType();
            if (rightType == null) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            if (!MethodUtils.isEquals((PsiMethod)method)) {
                return;
            }
            assert (methodCall.getInvokedExpression() instanceof GrReferenceExpression);
            GrReferenceExpression methodExpression = (GrReferenceExpression)methodCall.getInvokedExpression();
            PsiType leftType = PsiImplUtil.getQualifierType(methodExpression);
            if (leftType == null) {
                return;
            }
            if (TypeUtils.areConvertible((PsiType)rightType, (PsiType)leftType)) {
                return;
            }
            this.registerMethodCallError(methodCall, "equals()", leftType.getPresentableText(), rightType.getPresentableText());
        }
    }
}

