/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.editor.GroovyImportOptimizer;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class GroovyOptimizeImportsFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.codeInspection.local.GroovyPostHighlightingPass");
    private final boolean onTheFly;

    public GroovyOptimizeImportsFix(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Runnable optimize = new GroovyImportOptimizer().processFile(file);
        GroovyOptimizeImportsFix.invokeOnTheFlyImportOptimizer(optimize, file, editor);
    }

    @NotNull
    public String getText() {
        return GroovyInspectionBundle.message("optimize.all.imports", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return GroovyInspectionBundle.message("optimize.imports", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return file instanceof GroovyFile && (!this.onTheFly || this.timeToOptimizeImports((GroovyFile)file, editor));
    }

    private boolean timeToOptimizeImports(GroovyFile myFile, Editor editor) {
        DaemonCodeAnalyzerImpl codeAnalyzer;
        GrImportStatement[] imports;
        VirtualFile vfile;
        if (!CodeInsightSettings.getInstance().OPTIMIZE_IMPORTS_ON_THE_FLY) {
            return false;
        }
        if (this.onTheFly && editor != null && (vfile = myFile.getVirtualFile()) != null && ProjectRootManager.getInstance((Project)myFile.getProject()).getFileIndex().isInSource(vfile) && (imports = myFile.getImportStatements()).length > 0) {
            int offset = editor.getCaretModel().getOffset();
            if (imports[0].getTextRange().getStartOffset() <= offset && offset <= imports[imports.length - 1].getTextRange().getEndOffset()) {
                return false;
            }
        }
        if (!(codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)myFile.getProject())).isHighlightingAvailable((PsiFile)myFile)) {
            return false;
        }
        if (!codeAnalyzer.isErrorAnalyzingFinished((PsiFile)myFile)) {
            return false;
        }
        Document myDocument = PsiDocumentManager.getInstance((Project)myFile.getProject()).getDocument((PsiFile)myFile);
        boolean errors = this.containsErrorsPreventingOptimize(myFile, myDocument);
        return !errors && DaemonListeners.canChangeFileSilently((PsiFileSystemItem)myFile);
    }

    private boolean containsErrorsPreventingOptimize(GroovyFile myFile, Document myDocument) {
        TextRange ignoreRange;
        GrImportStatement[] imports = myFile.getImportStatements();
        if (imports.length != 0) {
            int start = imports[0].getTextRange().getStartOffset();
            int end = imports[imports.length - 1].getTextRange().getEndOffset();
            ignoreRange = new TextRange(start, end);
        } else {
            ignoreRange = TextRange.EMPTY_RANGE;
        }
        return !DaemonCodeAnalyzerEx.processHighlights((Document)myDocument, (Project)myFile.getProject(), (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)myDocument.getTextLength(), (Processor)new Processor<HighlightInfo>(){

            public boolean process(HighlightInfo error) {
                int infoEnd;
                int infoStart = error.getActualStartOffset();
                return ignoreRange.containsRange(infoStart, infoEnd = error.getActualEndOffset()) && error.type.equals(HighlightInfoType.WRONG_REF);
            }
        });
    }

    public static void invokeOnTheFlyImportOptimizer(final @NotNull Runnable runnable, final @NotNull PsiFile file, final @NotNull Editor editor) {
        final long stamp = editor.getDocument().getModificationStamp();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String afterText;
                if (file.getProject().isDisposed() || editor.isDisposed() || editor.getDocument().getModificationStamp() != stamp) {
                    return;
                }
                UndoManager undoManager = UndoManager.getInstance((Project)editor.getProject());
                if (undoManager.isUndoInProgress() || undoManager.isRedoInProgress()) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
                String beforeText = file.getText();
                long oldStamp = editor.getDocument().getModificationStamp();
                DocumentUtil.writeInRunUndoTransparentAction((Runnable)runnable);
                if (oldStamp != editor.getDocument().getModificationStamp() && Comparing.strEqual((String)beforeText, (String)(afterText = file.getText()))) {
                    String path = file.getViewProvider().getVirtualFile().getPath();
                    LOG.error("Import optimizer  hasn't optimized any imports", new Attachment[]{new Attachment(path, afterText)});
                }
            }
        });
    }
}

