/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrTypeDefinitionRangeHandler
implements DeclarationRangeHandler<GrTypeDefinition> {
    @NotNull
    public TextRange getDeclarationRange(@NotNull GrTypeDefinition aClass) {
        if (aClass instanceof GrAnonymousClassDefinition) {
            GrNewExpression call = (GrNewExpression)aClass.getParent();
            int startOffset = call.getTextRange().getStartOffset();
            int endOffset = call.getArgumentList().getTextRange().getEndOffset();
            return new TextRange(startOffset, endOffset);
        }
        GrModifierList modifierList = aClass.getModifierList();
        int startOffset = modifierList == null ? aClass.getTextRange().getStartOffset() : modifierList.getTextRange().getStartOffset();
        GrImplementsClause implementsList = aClass.getImplementsClause();
        int endOffset = implementsList == null ? aClass.getTextRange().getEndOffset() : implementsList.getTextRange().getEndOffset();
        return new TextRange(startOffset, endOffset);
    }
}

