/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.GrReferenceHighlighter;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class GrReferenceHighlighterFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public GrReferenceHighlighterFactory(Project project, TextEditorHighlightingPassRegistrar registrar) {
        super(project);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (!GrReferenceHighlighterFactory.isSpecificScriptFile(file) && !GrFileIndexUtil.isGroovySourceFile(file)) {
            return null;
        }
        return new GrReferenceHighlighter(editor.getDocument(), (GroovyFileBase)file);
    }

    private static boolean isSpecificScriptFile(@NotNull PsiFile file) {
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        if (!((GroovyFile)file).isScript()) {
            return false;
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])GroovyScriptTypeDetector.EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile((GroovyFile)file)) continue;
            return true;
        }
        return false;
    }
}

